package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public class MaidMoveToPredicateBlockTask extends MaidMoveToBlockTask {
    private final Predicate<EntityMaid> searchCondition;
    private final BiPredicate<EntityMaid, class_2338> blockPredicate;

    public MaidMoveToPredicateBlockTask(float movementSpeed, int verticalSearchRange,
                                        @Nullable Predicate<EntityMaid> searchCondition,
                                        @Nullable BiPredicate<EntityMaid, class_2338> blockPredicate) {
        super(movementSpeed, verticalSearchRange);
        this.searchCondition = Objects.requireNonNullElseGet(searchCondition, () -> entity -> false);
        this.blockPredicate = Objects.requireNonNullElseGet(blockPredicate, () -> (entity, pos) -> false);
    }

    @Override
    protected void start(class_3218 pLevel, EntityMaid pEntity, long pGameTime) {
        if (searchCondition.test(pEntity)) {
            searchForDestination(pLevel, pEntity);
        }
    }

    @Override
    protected boolean shouldMoveTo(class_3218 worldIn, EntityMaid entityIn, class_2338 pos) {
        return blockPredicate.test(entityIn, pos);
    }

    @Override
    protected boolean checkPathReach(EntityMaid maid, MaidPathFindingBFS pathFinding, class_2338 pos) {
        // 检测周围 3x3x2 的方块是否可达
        for (int x = -1; x <= 1; x++) {
            for (int y = 0; y <= 1; y++) {
                for (int z = -1; z <= 1; z++) {
                    if (pathFinding.canPathReach(pos.method_10069(x, y, z))) {
                        return true;
                    }
                }
            }
        }
        return false;
    }
}