package com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation;

import com.github.tartaricacid.touhoulittlemaid.util.CenterOffsetBlockPosSet;
import net.minecraft.class_1308;
import net.minecraft.class_15;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_7;
import net.minecraft.class_9;
import org.jetbrains.annotations.Nullable;

/**
 * 水下的寻路节点计算器，修改了起点计算方法
 */
public class MaidUnderWaterNodeEvaluator extends class_15 implements ICachedEvaluator, INodeCacheEvaluator {
    protected CenterOffsetBlockPosSet vis;

    public MaidUnderWaterNodeEvaluator() {
        // 倾向于浅处游泳？那不是好事一桩？
        super(true);
    }

    @Override
    public void method_12(class_1950 pLevel, class_1308 pMob) {
        super.method_12(pLevel, pMob);
    }

    @Override
    public void method_19() {
        super.method_19();
        vis = null;
    }

    @Override
    public class_9 method_21() {
        int x = class_3532.method_15357(this.field_33.method_5829().field_1323);
        int y = class_3532.method_15357(this.field_33.method_5829().field_1322 + 0.5);
        int z = class_3532.method_15357(this.field_33.method_5829().field_1321);
        return this.method_43415(new class_2338(x, y, z));
    }

    @Override
    public void init(int x, int y, int z, int cx, int cy, int cz) {
        vis = new CenterOffsetBlockPosSet(x, y, z, cx, cy, cz);
    }

    @Override
    public void markVis(class_2338 pPos) {
        vis.markVis(pPos);
    }

    /**
     * 使得出水路径能够在水面上一格生成路径点，使得女仆不容易卡在水底
     */
    @Override
    public int method_18(class_9[] outputArray, class_9 node) {
        int nodeId = super.method_18(outputArray, node);
        class_2338 blockPos = node.method_22879();
        if (field_20622.method_8316(blockPos).method_15767(class_3486.field_15517) && field_20622.method_8316(blockPos.method_10084()).method_15769()) {
            class_9 aboveNode = this.method_13(node.field_40, node.field_39 + 1, node.field_38);
            if (!aboveNode.field_42) {
                aboveNode.field_43++;
                outputArray[nodeId++] = aboveNode;
            }
        }
        return nodeId;
    }

    /**
     * 删除斜向上岸的路径
     */
    @Override
    protected boolean method_20536(@Nullable class_9 neighbor, class_9 node) {
        // 快速可达判断的缓存机制
        if (neighbor != null && vis != null && vis.isVis(neighbor.method_22879())) {
            return false;
        }
        class_2338 blockPos = node.method_22879();
        if (neighbor != null && field_20622.method_8316(blockPos).method_15767(class_3486.field_15517)
                && field_20622.method_8316(neighbor.method_22879()).method_15769()
                && node.field_39 != neighbor.field_39 && (node.field_40 != neighbor.field_40 || node.field_38 != neighbor.field_38)) {
            return false;
        }
        return super.method_20536(neighbor, node);
    }

    @Nullable
    @Override
    protected class_9 method_62(int pX, int pY, int pZ, int verticalDeltaLimit, double nodeFloorLevel, class_2350 direction, class_7 pathType) {
        // 快速可达判断的缓存机制
        if (vis != null && vis.isVis(pX, pY, pZ)) {
            return null;
        }
        return super.method_62(pX, pY, pZ, verticalDeltaLimit, nodeFloorLevel, direction, pathType);
    }

    @Override
    public class_9 createNode(int x, int y, int z) {
        return method_13(x, y, z);
    }
}