package com.github.tartaricacid.touhoulittlemaid.entity.item.control;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IBroomControl;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBroom;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class PlayerBroomControl implements IBroomControl {
    private final EntityBroom broom;

    public PlayerBroomControl(EntityBroom broom) {
        this.broom = broom;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public boolean inControl(class_1657 player, @Nullable EntityMaid maid) {
        return true;
    }

    @Override
    public void travel(class_1657 player, EntityMaid maid) {
        boolean keyForward = player.field_6250 > 0;
        boolean keyBack = player.field_6250 < 0;
        boolean keyLeft = player.field_6212 > 0;
        boolean keyRight = player.field_6212 < 0;
        boolean keySneak = player.method_5715();
        boolean keyJump = IBroomControl.keyJump(player);

        class_243 currentMotion = broom.method_18798();
        boolean hasInput = keyForward || keyBack || keyLeft || keyRight || keyJump || keySneak;

        if (hasInput) {
            float strafe = keyLeft ? 0.2f : (keyRight ? -0.2f : 0);
            float vertical = 0;

            // 垂直移动控制
            if (keyJump) {
                vertical = 0.25f;
            } else if (keySneak) {
                vertical = -0.2f;
            } else if (keyForward) {
                // 原有的俯仰控制
                vertical = -(player.method_36455() - 10) / 360f;
            }

            float forward = keyForward ? 0.375f : (keyBack ? -0.2f : 0);

            // 玩家基础速度是 0.1，速度二效果是 0.14，为了增加速度效果带来的增益，故这样计算
            double playerSpeed = player.method_26825(class_5134.field_23719);
            double speed = Math.max(playerSpeed - 0.1, 0) * 2.5 + 0.1;
            class_243 targetMotion = new class_243(strafe, vertical, forward).method_1021(speed * 20);
            targetMotion = targetMotion.method_1024((float) (-broom.method_36454() * Math.PI / 180.0));

            // 插值到目标速度，而不是直接累加
            class_243 newMotion = currentMotion.method_35590(targetMotion, 0.25f);

            broom.method_18799(newMotion);
        } else {
            // 没有输入时，快速减速
            broom.method_18799(currentMotion.method_1021(0.75));
        }
    }

    @Override
    public void tickRot(class_1657 player, EntityMaid maid) {
        broom.field_5982 = broom.field_6283 = broom.field_6241 = broom.method_36454();
        broom.method_5710(player.method_36454(), player.method_36455());
    }
}