package com.github.tartaricacid.touhoulittlemaid.entity.misc;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1569;
import net.minecraft.class_1655;
import net.minecraft.class_1657;

public final class DefaultMonsterType {
    public static MonsterType getMonsterType(class_1309 target) {
        // 如果继承了 Enemy 接口，那就是敌对生物
        if (target instanceof class_1569) {
            return MonsterType.HOSTILE;
        }

        // 如果是玩家、宠物、NPC、归为友好
        if (target instanceof class_1321 || target instanceof class_1655) {
            return MonsterType.FRIENDLY;
        }

        // 否则归为中立
        return MonsterType.NEUTRAL;
    }

    public static boolean canAttack(EntityMaid maid, class_1309 target, MonsterType monsterType) {
        // 友好生物，无论什么情况不攻击
        if (monsterType == MonsterType.FRIENDLY) {
            return false;
        }

        // 中立生物，只有玩家攻击的，或者攻击过玩家的才会攻击
        if (monsterType == MonsterType.NEUTRAL) {
            return checkNeutral(maid, target);
        }

        // 其他的，那只有敌对了，攻击
        return true;
    }

    private static boolean checkNeutral(EntityMaid maid, class_1309 target) {
        // 先判断主人
        if (maid.method_35057() instanceof class_1657 player) {
            // 获取攻击主人的生物
            class_1309 lastHurtByMob = player.method_6065();
            if (target.equals(lastHurtByMob)) {
                return true;
            }
            // 获取主人攻击过的生物
            class_1309 lastHurtMob = player.method_6052();
            if (target.equals(lastHurtMob)) {
                return true;
            }
        }

        // 再判断女仆自身被攻击的
        class_1309 maidLastHurtByMob = maid.method_6065();
        return target.equals(maidLastHurtByMob);
    }
}