package com.github.tartaricacid.touhoulittlemaid.entity.monster;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import net.minecraft.class_1309;
import net.minecraft.class_1928;

public interface IHasPowerPoint {
    /**
     * 获取 Power 点数值
     *
     * @return Power 点数值，与玩家 Power 数是 100 倍的关系
     */
    int getPowerPoint();

    /**
     * 掉落 P 点的方法
     *
     * @param entity 掉落该 P 点的实体
     */
    default void dropPowerPoint(class_1309 entity) {
        // 需要考虑 doMobLoot 规则
        if (!entity.field_6002.method_8450().method_8355(class_1928.field_19391)) {
            return;
        }
        int dropTime = 20;
        if (entity.field_6213 == dropTime && !entity.field_6002.field_9236) {
            int totalPowerPoint = getPowerPoint();
            while (totalPowerPoint > 0) {
                int powerSplit = EntityPowerPoint.getPowerValue(totalPowerPoint);
                totalPowerPoint -= powerSplit;
                EntityPowerPoint powerPoint = new EntityPowerPoint(entity.field_6002, entity.method_23317(), entity.method_23318(), entity.method_23321(), powerSplit);
                entity.field_6002.method_8649(powerPoint);
            }
        }
    }
}
