package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1821;
import net.minecraft.class_2338;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;

public class TaskSnow implements IFarmTask {
    public static final class_2960 UID = new class_2960(TouhouLittleMaid.MOD_ID, "snow");

    @Override
    public class_2960 getUid() {
        return UID;
    }

    @Override
    public class_1799 getIcon() {
        return class_1802.field_8543.method_7854();
    }

    @Override
    public class_3414 getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound(maid, InitSounds.MAID_REMOVE_SNOW, 0.5f);
    }

    @Override
    public boolean isSeed(class_1799 stack) {
        return false;
    }

    @Override
    public boolean canHarvest(EntityMaid maid, class_2338 cropPos, class_2680 cropState) {
        return cropState.method_26204() instanceof class_2488;
    }

    @Override
    public void harvest(EntityMaid maid, class_2338 cropPos, class_2680 cropState) {
        class_1799 mainHandItem = maid.method_6047();
        if (mainHandItem.method_7909() instanceof class_1821) {
            if (maid.destroyBlock(cropPos)) {
                mainHandItem.method_7956(1, maid, (e) -> e.method_20236(class_1268.field_5808));
            }
        } else {
            maid.destroyBlock(cropPos, false);
        }
    }

    @Override
    public boolean canPlant(EntityMaid maid, class_2338 basePos, class_2680 baseState, class_1799 seed) {
        return false;
    }

    @Override
    public class_1799 plant(EntityMaid maid, class_2338 basePos, class_2680 baseState, class_1799 seed) {
        return seed;
    }
}
