package com.github.tartaricacid.touhoulittlemaid.entity.task.crop;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.task.ISpecialCropHandler;
import com.github.tartaricacid.touhoulittlemaid.compat.kaleidoscope.KaleidoscopeCompat;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;

public class SpecialCropManager {
    private static Map<class_1792, ISpecialCropHandler> ITEM_SEED_HANDLERS = Maps.newHashMap();
    private static Map<class_2248, ISpecialCropHandler> BLOCK_CROP_HANDLERS = Maps.newHashMap();

    private SpecialCropManager() {
    }

    public static void init() {
        SpecialCropManager manager = new SpecialCropManager();

        manager.add(class_1802.field_8790, class_2246.field_9974, new NetherWartCropHandler());
        KaleidoscopeCompat.addCropHandlers(manager);
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            littleMaid.registerSpecialCropHandler(manager);
        }

        ITEM_SEED_HANDLERS = ImmutableMap.copyOf(ITEM_SEED_HANDLERS);
        BLOCK_CROP_HANDLERS = ImmutableMap.copyOf(BLOCK_CROP_HANDLERS);
    }

    public static Map<class_1792, ISpecialCropHandler> getItemSeedHandlers() {
        return ITEM_SEED_HANDLERS;
    }

    public static Map<class_2248, ISpecialCropHandler> getBlockCropHandlers() {
        return BLOCK_CROP_HANDLERS;
    }

    public void add(class_1792 seed, class_2248 crop, ISpecialCropHandler handler) {
        ITEM_SEED_HANDLERS.put(seed, handler);
        BLOCK_CROP_HANDLERS.put(crop, handler);
    }

    public void addSeed(class_1792 seed, ISpecialCropHandler handler) {
        ITEM_SEED_HANDLERS.put(seed, handler);
    }

    public void addCrop(class_2248 crop, ISpecialCropHandler handler) {
        BLOCK_CROP_HANDLERS.put(crop, handler);
    }
}