package com.github.tartaricacid.touhoulittlemaid.inventory.container.other;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.IItemHandler;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemStackHandler;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.SlotItemHandler;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemWirelessIO;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;

public class WirelessIOContainer extends class_1703 {
    public static final class_3917<WirelessIOContainer> TYPE = new ExtendedScreenHandlerType<>(
            (id, inv, data) -> new WirelessIOContainer(id, inv, data.method_10819())
    );
    private final class_1799 wirelessIO;
    private final ItemStackHandler filterListInv;

    public WirelessIOContainer(int id, class_1661 inventory, class_1799 wirelessIO) {
        super(TYPE, id);
        this.wirelessIO = wirelessIO;
        this.filterListInv = ItemWirelessIO.getFilterList(wirelessIO);
        this.addPlayerSlots(inventory);
        this.addWirelessIOSlots();
    }

    @Override
    public boolean method_7597(class_1657 playerIn) {
        return playerIn.method_6047().method_7909() == InitItems.WIRELESS_IO;
    }

    @Override
    public void method_7593(int slotId, int button, class_1713 clickTypeIn, class_1657 player) {
        // 禁阻一切对当前手持物品的交互，防止刷物品 bug
        if (slotId == 27 + player.method_31548().field_7545) {
            return;
        }
        if (clickTypeIn == class_1713.field_7791) {
            return;
        }
        super.method_7593(slotId, button, clickTypeIn, player);
        ItemWirelessIO.setFilterList(wirelessIO, filterListInv);
    }

    private void addWirelessIOSlots() {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.method_7621(new WirelessIOSlotItemHandler(filterListInv, col + row * 3, 62 + col * 18, 17 + row * 18));
            }
        }
    }

    private void addPlayerSlots(class_1661 inventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.method_7621(new class_1735(inventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }

        for (int col = 0; col < 9; ++col) {
            this.method_7621(new class_1735(inventory, col, 8 + col * 18, 142));
        }
    }

    @Override
    public class_1799 method_7601(class_1657 playerIn, int index) {
        class_1799 stack1 = class_1799.field_8037;
        class_1735 slot = this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 stack2 = slot.method_7677();
            stack1 = stack2.method_7972();
            if (index < 27) {
                if (!this.method_7616(stack2, 27, 36, true)) {
                    return class_1799.field_8037;
                }
            } else if (!this.method_7616(stack2, 0, 27, false)) {
                return class_1799.field_8037;
            }
            if (stack2.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return stack1;
    }

    public class_1799 getWirelessIO() {
        return wirelessIO;
    }

    private class WirelessIOSlotItemHandler extends SlotItemHandler {
        private WirelessIOSlotItemHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        @Override
        public int method_7675() {
            return 1;
        }

        @Override
        public boolean method_7680(@NotNull class_1799 stack) {
            return EntityMaid.canInsertItem(stack) && super.method_7680(stack);
        }
    }
}
