package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityModelSwitcher;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import java.util.List;

public class ItemModelSwitcher extends class_1747 {
    private static final String STORAGE_DATA_TAG = "StorageData";
    private static final String FORGE_DATA_TAG = "ForgeData";

    public ItemModelSwitcher() {
        super(InitBlocks.MODEL_SWITCHER, (new class_1792.class_1793()).method_7889(1));
    }

    public static class_1799 tileEntityToItemStack(TileEntityModelSwitcher switcher) {
        class_1799 stack = InitItems.MODEL_SWITCHER.method_7854();
        class_2487 stackTag = stack.method_7948();
        stackTag.method_10566(STORAGE_DATA_TAG, switcher.method_38244());
        return stack;
    }

    public static void itemStackToTileEntity(class_1799 stack, TileEntityModelSwitcher switcher) {
        class_2487 tag = stack.method_7911(STORAGE_DATA_TAG);
        if (tag.method_10573(FORGE_DATA_TAG, class_2520.field_33260)) {
            switcher.method_11014(tag);
        }
    }

    @Override
    public class_1269 method_7847(class_1799 pStack, class_1657 pPlayer, class_1309 pInteractionTarget, class_1268 pUsedHand) {
        if (pInteractionTarget instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid) pInteractionTarget;
            class_2487 tag = pStack.method_7911(STORAGE_DATA_TAG);
            class_2487 forgeData;
            if (tag.method_10573(FORGE_DATA_TAG, class_2520.field_33260)) {
                forgeData = tag.method_10562(FORGE_DATA_TAG);
            } else {
                forgeData = new class_2487();
            }
            forgeData.method_10566(TileEntityModelSwitcher.ENTITY_UUID, class_2512.method_25929(maid.method_5667()));
            tag.method_10566(FORGE_DATA_TAG, forgeData);
            return class_1269.field_5812;
        }
        return super.method_7847(pStack, pPlayer, pInteractionTarget, pUsedHand);
    }

    private boolean hasMaidInfo(class_1799 stack) {
        class_2487 tag = stack.method_7941(STORAGE_DATA_TAG);
        if (tag != null && tag.method_10573(FORGE_DATA_TAG, class_2520.field_33260)) {
            class_2487 forgeTag = tag.method_10562(FORGE_DATA_TAG);
            return forgeTag.method_10573(TileEntityModelSwitcher.ENTITY_UUID, class_2520.field_33261);
        }
        return false;
    }

    @Override
    public void method_7851(class_1799 pStack, @Nullable class_1937 pLevel, List<class_2561> pTooltip, class_1836 pFlag) {
        if (hasMaidInfo(pStack)) {
            pTooltip.add(class_2561.method_43471("tooltips.touhou_little_maid.model_switcher.bounded").method_27692(class_124.field_1080));
        } else {
            pTooltip.add(class_2561.method_43471("gui.touhou_little_maid.model_switcher.uuid.empty").method_27692(class_124.field_1079));
        }
    }
}
