package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidInfo;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import java.util.List;

public class ItemTrumpet extends class_1792 {
    private static final int MIN_USE_DURATION = 20;

    public ItemTrumpet() {
        super((new class_1793()).method_7889(1));
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 worldIn, class_1309 entityLiving, int timeLeft) {
        if (entityLiving instanceof class_1657 player && timeLeft >= MIN_USE_DURATION) {
            if (worldIn instanceof class_3218) {
                ((class_3218) worldIn).method_18198(EntityMaid.TYPE, class_1297::method_5805).stream()
                        .filter(maid -> maid.method_6171(player))
                        .forEach(maid -> teleportToOwner(maid, player));
                MaidWorldData data = MaidWorldData.get(worldIn);
                if (data != null) {
                    List<MaidInfo> infos = data.getPlayerMaidInfos(player);
                    if (infos != null && !infos.isEmpty()) {
                        player.method_43496(class_2561.method_43469("message.touhou_little_maid.trumpet.unloaded_maid", infos.size()).method_27692(class_124.field_1079));
                    }
                }
            }
            if (player instanceof class_3222 serverPlayer) {
                InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.USE_TRUMPET);
            }
            player.method_7357().method_7906(this, 200);
        }
    }

    private void teleportToOwner(EntityMaid maid, class_1657 player) {
        maid.setHomeModeEnable(false);
        maid.method_5859(player.method_23317() + player.method_6051().method_43048(3) - 1, player.method_23318(), player.method_23321() + player.method_6051().method_43048(3) - 1);
    }

    @Override
    public int method_7881(class_1799 stack) {
        return 100;
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        class_1799 stack = playerIn.method_5998(handIn);
        playerIn.method_6019(handIn);
        return class_1271.method_22428(stack);
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        tooltip.add(class_2561.method_43471("tooltips.touhou_little_maid.trumpet.desc.usage").method_27692(class_124.field_1080));
        tooltip.add(class_2561.method_43471("tooltips.touhou_little_maid.trumpet.desc.note").method_27692(class_124.field_1079));
    }
}
