package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticleMessage;
import net.minecraft.class_1282;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_8103;
import org.apache.commons.lang3.mutable.MutableFloat;

public class MagicProtectBauble implements IMaidBauble {
    @Override
    public boolean onInjured(EntityMaid maid, class_1799 baubleItem, class_1282 source, MutableFloat damage) {
        if (source.method_48789(class_8103.field_42248)) {
            baubleItem.method_7956(1, maid, m -> maid.sendItemBreakMessage(baubleItem));
            maid.method_6012();
            NetworkHandler.sendToNearby(maid, SpawnParticleMessage.ID, SpawnParticleMessage.encode(maid.method_5628(), SpawnParticleMessage.Type.EXPLOSION));
            if (maid.method_35057() instanceof class_3222 serverPlayer) {
                InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.USE_PROTECT_BAUBLE);
            }
            return true;
        }
        return false;
    }
}
