package com.github.tartaricacid.touhoulittlemaid.loot;

import com.github.tartaricacid.touhoulittlemaid.datapack.BoardStateData;
import com.github.tartaricacid.touhoulittlemaid.datapack.pojo.BoardStateRecord;
import com.github.tartaricacid.touhoulittlemaid.init.InitLootModifier;
import com.github.tartaricacid.touhoulittlemaid.item.ItemBoardState;
import com.github.tartaricacid.touhoulittlemaid.util.WeightedPicker;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_1799;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;

public class RandomBoardStateFunction extends class_120 {
    /**
     * 会选择的残局所具有的 tag
     */
    private final List<String> tags;

    protected RandomBoardStateFunction(class_5341[] predicates, List<String> tags) {
        super(predicates);
        this.tags = tags;
    }

    public static RandomBoardStateFunction.Builder create() {
        return new RandomBoardStateFunction.Builder();
    }


    private boolean checkTags(BoardStateRecord record) {
        for (String tag : tags) {
            if (record.tags().contains(tag)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected class_1799 method_522(class_1799 stack, class_47 context) {
        List<BoardStateRecord> records = BoardStateData.getRecordsByItem(stack);
        if (records.isEmpty()) {
            return stack;
        }
        if (this.tags.isEmpty()) {
            return stack;
        }
        List<BoardStateRecord> matchedRecords = records.stream().filter(this::checkTags).toList();
        if (matchedRecords.isEmpty()) {
            return stack;
        }
        BoardStateRecord selected = WeightedPicker.pickRandom(matchedRecords, BoardStateRecord::weight);
        if (selected == null) {
            return stack;
        }
        BoardStateRecord.Display display = selected.display();
        ItemBoardState.setState(stack, selected.data(), display.description(), display.author());
        return stack;
    }

    @Override
    public class_5339 method_29321() {
        return InitLootModifier.BOARD_STATE_RANDOMLY;
    }

    public static class Builder extends class_120.class_121<RandomBoardStateFunction.Builder> {
        private final List<String> tags = Lists.newArrayList();

        @Override
        protected Builder method_523() {
            return this;
        }

        public RandomBoardStateFunction.Builder addTag(String tag) {
            this.tags.add(tag);
            return this;
        }

        @Override
        public class_117 method_515() {
            return new RandomBoardStateFunction(this.method_526(), this.tags);
        }
    }

    public static class Serializer extends class_120.class_123<RandomBoardStateFunction> {
        @Override
        public void serialize(JsonObject json, RandomBoardStateFunction function, JsonSerializationContext context) {
            super.method_529(json, function, context);
            if (function.tags.isEmpty()) {
                return;
            }
            JsonArray tags = new JsonArray();
            for (String tag : function.tags) {
                tags.add(tag);
            }
            json.add("tags", tags);
        }

        @Override
        public RandomBoardStateFunction method_530(JsonObject object, JsonDeserializationContext context, class_5341[] conditions) {
            if (!object.has("tags")) {
                return new RandomBoardStateFunction(conditions, Collections.emptyList());
            }
            JsonArray inputTags = object.getAsJsonArray("tags");
            if (inputTags.size() <= 0) {
                return new RandomBoardStateFunction(conditions, Collections.emptyList());
            }
            List<String> outputTags = Lists.newArrayList();
            for (int i = 0; i < inputTags.size(); i++) {
                String tag = inputTags.get(i).getAsString();
                outputTags.add(tag);
            }
            return new RandomBoardStateFunction(conditions, outputTags);
        }
    }
}