package com.github.tartaricacid.touhoulittlemaid.mixin;

import com.github.tartaricacid.touhoulittlemaid.api.mixin.IBlockBurningCacheMixin;
import net.minecraft.class_14;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_14.class)
public class NodeEvaluatorBurningCacher {
    @Inject(method = "isBurningBlock", at = @At("HEAD"), cancellable = true)
    private static void isBurningBlock(class_2680 state, CallbackInfoReturnable<Boolean> cir) {
        class_2248 b = state.method_26204();
        if (b instanceof IBlockBurningCacheMixin block) {
            if (block.touhou_little_maid$isBurning() != null) {
                cir.setReturnValue(block.touhou_little_maid$isBurning());
            }
        }
    }

    @Inject(method = "isBurningBlock", at = @At("RETURN"))
    private static void postIsBurningBlock(class_2680 state, CallbackInfoReturnable<Boolean> cir) {
        class_2248 b = state.method_26204();
        if (b instanceof IBlockBurningCacheMixin block) {
            if (block.touhou_little_maid$cannotCache() != null && block.touhou_little_maid$cannotCache()) {
                return;
            }
            Class<? extends class_2248> c = b.getClass();
            if (c != class_2248.class) {
                try {
                    c.getDeclaredMethod("is", class_2248.class);
                    block.touhou_little_maid$setCannotCache(true);
                    return;
                } catch (NoSuchMethodException ignored) {
                }
                try {
                    c.getDeclaredMethod("is", class_6862.class);
                    block.touhou_little_maid$setCannotCache(true);
                    return;
                } catch (NoSuchMethodException ignored) {
                }
                try {
                    c.getDeclaredMethod("is", class_6880.class);
                    block.touhou_little_maid$setCannotCache(true);
                    return;
                } catch (NoSuchMethodException ignored) {
                }
                try {
                    c.getDeclaredMethod("is", class_6885.class);
                    block.touhou_little_maid$setCannotCache(true);
                    return;
                } catch (NoSuchMethodException ignored) {
                }
            }
            block.touhou_little_maid$setBurning(cir.getReturnValue());
        }
    }
}