package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_638;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.getResourceLocation;

/**
 * 用于同步客户端播放动画的消息
 * 目前只包含拾取雪球的动画
 */
public class MaidAnimationMessage {
    public static final class_2960 ID = getResourceLocation("maid_animation");

    public static final int NONE = 0;
    public static final int PICK_UP_SNOWBALL = 1;
    public static final int SWF_AIM = 2;
    public static final int SWF_RELOAD = 3;
    public static final int SWF_FIRE = 4;

    public static class_2540 pickUpSnowball(EntityMaid maid) {
        // 播放丢雪球动画之前，先禁止女仆移动
        // 标记服务端事件
        maid.animationId = PICK_UP_SNOWBALL;
        maid.animationRecordTime = System.currentTimeMillis();
        // 返回消息
        return encode(maid.method_5628(), PICK_UP_SNOWBALL);
    }

    public static class_2540 encode(int maidId, int animationId) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(maidId);
        buf.writeInt(animationId);
        return buf;
    }

    public static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        int maidId = buf.readInt();
        int animationId = buf.readInt();
        client.execute(() -> handle(maidId, animationId));
    }

    @Environment(EnvType.CLIENT)
    private static void handle(int maidId, int animationId) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        if (level.method_8469(maidId) instanceof EntityMaid maid) {
            maid.animationId = animationId;
            maid.animationRecordTime = System.currentTimeMillis();
            maid.shouldReset = true;
        }
    }
}