package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.cache.CacheIconManager;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.getResourceLocation;

public class OpenChairGuiMessage {
    public static final class_2960 ID = getResourceLocation("open_chair_gui");

    public static class_2540 encode(int id) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(id);
        return buf;
    }

    public static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        int id = buf.readInt();
        client.execute(() -> handleOpenGui(id));
    }

    @Environment(EnvType.CLIENT)
    private static void handleOpenGui(int id) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        class_1297 e = mc.field_1687.method_8469(id);
        if (mc.field_1724 != null && mc.field_1724.method_5805() && e instanceof EntityChair chair && e.method_5805()) {
            CacheIconManager.openChairModelGui(chair);
        }
    }
}
