package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.ChatClientInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.getResourceLocation;

public class SendUserChatMessage {
    public static final class_2960 ID = getResourceLocation("send_user_chat");

    public static class_2540 encode(int maidId, String message, ChatClientInfo clientInfo) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(maidId);
        buf.method_10814(message);
        clientInfo.encode(buf);
        return buf;
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        int maidId = buf.method_10816();
        String message = buf.method_19772();
        ChatClientInfo clientInfo = ChatClientInfo.decode(buf);
        server.execute(() -> onHandle(maidId, message, clientInfo, player));
    }

    private static void onHandle(int maidId, String message, ChatClientInfo clientInfo, class_3222 sender) {
        class_1297 entity = sender.field_6002.method_8469(maidId);
        if (entity instanceof EntityMaid maid && maid.method_6171(sender) && maid.method_5805()) {
            maid.getAiChatManager().chat(message, clientInfo, sender);
        }
    }
}
