package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.site.AvailableSites;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSConfig;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSSystemServices;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.apache.commons.lang3.tuple.Pair;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.getResourceLocation;

public class TTSSystemAudioToClientMessage {
    public static final class_2960 ID = getResourceLocation("tts_system_audio_to_client");

    public static class_2540 encode(String siteName, String chatText, TTSConfig config, TTSSystemServices services) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(siteName);
        services.writeToNetwork(chatText, config, buf);
        return buf;
    }

    public static void handle(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        String siteName = buf.method_19772();
        TTSSite ttsSite = AvailableSites.getTTSSite(siteName);
        if (ttsSite.client() instanceof TTSSystemServices services) {
            Pair<String, TTSConfig> pair = services.readFromNetwork(buf);
            client.execute(() -> onHandle(siteName, pair.getLeft(), pair.getRight(), services));
        }
    }

    @Environment(EnvType.CLIENT)
    private static void onHandle(String siteName, String chatText, TTSConfig config, TTSSystemServices services) {
        TTSSite ttsSite = AvailableSites.getTTSSite(siteName);
        if (ttsSite == null || !ttsSite.enabled()) {
            return;
        }
        ttsSite.client().play(chatText, config, null);
    }
}
