package com.github.tartaricacid.touhoulittlemaid.util;

import com.google.gson.*;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nullable;
import net.minecraft.class_1299;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import java.util.Optional;

public final class EntityCraftingHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String TYPE_TAG = "type";
    private static final String NBT_TAG = "nbt";
    private static final String COPY_TAG = "copy";
    private static final String INGREDIENT_TAG = "ingredient";
    private static final String TAG_TAG = "tag";

    public static Output getEntityData(JsonObject json) {
        try {
            Optional<class_1299<?>> optional = class_1299.method_5898(class_3518.method_15265(json, TYPE_TAG));
            if (optional.isPresent()) {
                class_1299<?> type = optional.get();

                JsonElement nbtElement = json.get(NBT_TAG);
                class_2487 outputData = new class_2487();
                if (nbtElement != null) {
                    if (nbtElement.isJsonObject()) {
                        outputData = class_2522.method_10718(GSON.toJson(nbtElement));
                    } else {
                        outputData = class_2522.method_10718(class_3518.method_15287(nbtElement, NBT_TAG));
                    }
                }

                JsonElement copyElement = json.get(COPY_TAG);
                if (copyElement != null && copyElement.isJsonObject()) {
                    JsonObject copyObject = copyElement.getAsJsonObject();
                    class_1856 ingredient = class_1856.method_52177(copyObject.get(INGREDIENT_TAG));
                    String tag = null;
                    if (copyObject.has(TAG_TAG) && StringUtils.isNotBlank(copyObject.get(TAG_TAG).getAsString())) {
                        tag = copyObject.get(TAG_TAG).getAsString();
                    }
                    return new Output(type, outputData, ingredient, tag);
                }
                return new Output(type, outputData);
            }
            throw new JsonParseException("Entity Type Tag Not Found");
        } catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Invalid NBT Entry: " + e.toString());
        }
    }

    public static JsonObject writeEntityData(Output output) {
        JsonObject json = new JsonObject();
        class_2960 key = class_7923.field_41177.method_10221(output.type);
        if (key == class_7923.field_41177.method_10137()) {
            throw new JsonParseException("Entity Type Not Found: " + output.type);
        }
        json.addProperty(TYPE_TAG, key.toString());
        NBTToJson.getJson(output.getData()).ifPresent(e -> json.add(NBT_TAG, e));

        if (!output.getCopyInput().method_8103()) {
            JsonObject copyObject = new JsonObject();
            copyObject.add(INGREDIENT_TAG, output.getCopyInput().method_8089());
            if (StringUtils.isNotBlank(output.getCopyTag())) {
                copyObject.addProperty(TAG_TAG, output.getCopyTag());
            }
            json.add(COPY_TAG, copyObject);
        }
        return json;
    }

    public static class Output {
        private final class_1299<?> type;
        private final class_2487 data;
        private final class_1856 copyInput;
        private final String copyTag;

        public Output(class_1299<?> type, class_2487 data, class_1856 copyInput, @Nullable String copyTag) {
            this.type = type;
            this.data = data;
            this.copyInput = copyInput;
            this.copyTag = copyTag;
        }

        public Output(class_1299<?> type, class_2487 data) {
            this(type, data, class_1856.field_9017, null);
        }

        public class_1299<?> getType() {
            return type;
        }

        public class_2487 getData() {
            return data;
        }

        public class_1856 getCopyInput() {
            return copyInput;
        }

        @Nullable
        public String getCopyTag() {
            return copyTag;
        }
    }
}