package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_243;

public final class MaidRayTraceHelper {
    private MaidRayTraceHelper() {
    }

    /**
     * 来自于原版的获取实体指向对象的方法，
     * 很好奇为何原版将其设定为仅客户端方法
     *
     * @param player   玩家
     * @param distance 搜索距离
     * @return RayTraceResult 枚举
     */
    public static Optional<EntityMaid> rayTraceMaid(class_1657 player, double distance) {
        // 搜索玩家附近驯服的自己的实体
        List<class_1297> maidList = player.field_6002.method_8333(player, player.method_5829()
                .method_1009(distance, distance, distance), entity -> entity instanceof EntityMaid && ((EntityMaid) entity).method_6171(player));
        // 遍历附近实体，查看能否玩家看见
        for (class_1297 maid : maidList) {
            // 二次判定，以防万一
            if (maid.method_5805() && maid instanceof EntityMaid && isEntityBeLooked(player, maid) && ((EntityMaid) maid).method_6171(player)) {
                return Optional.of((EntityMaid) maid);
            }
        }
        return Optional.empty();
    }

    private static boolean isEntityBeLooked(class_1657 player, class_1297 lookEntity) {
        // 玩家朝向向量（标准化）
        class_243 lookVec = player.method_5720().method_1029();
        // 玩家和实体间构成的向量
        class_243 playerAndEntityVec = new class_243(lookEntity.method_23317() - player.method_23317(),
                lookEntity.method_5829().field_1322 + (double) lookEntity.method_5751() * 2 / 3 - (player.method_23318() + (double) player.method_5751()),
                lookEntity.method_23321() - player.method_23321());
        // 玩家和实体间的距离
        double playerAndEntityDistance = playerAndEntityVec.method_1033();
        // 玩家和实体间构成的向量（标准化）
        playerAndEntityVec = playerAndEntityVec.method_1029();
        // 标准化的向量，点乘得到的直接就是 cos 夹角值
        double cosAngle = lookVec.method_1026(playerAndEntityVec);
        // 最大偏差，与距离有关系，距离越远，偏差应该越小
        double maxDistanceDeviation = 0.075D / playerAndEntityDistance;
        // 最后再检查一次能否看见
        return cosAngle > 1.0D - maxDistanceDeviation && player.method_6057(lookEntity);
    }
}
