package com.github.tartaricacid.touhoulittlemaid.util;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public final class ParseI18n {
    private static final String I18N_START_CHAR = "{";
    private static final String I18N_END_CHAR = "}";

    private ParseI18n() {
    }

    /**
     * 获取本地化的 key
     */
    public static String getI18nKey(String strIn) {
        if (strIn.startsWith(I18N_START_CHAR) && strIn.endsWith(I18N_END_CHAR)) {
            return strIn.substring(1, strIn.length() - 1);
        } else {
            return strIn;
        }
    }

    public static String getI18nValue(String strIn) {
        return class_1074.method_4662(getI18nKey(strIn));
    }

    /**
     * 将传入的字符串进行国际化
     */
    public static class_5250 parse(String strIn) {
        // 如果是“{ ”开头，“} ”结尾
        if (strIn.startsWith(I18N_START_CHAR) && strIn.endsWith(I18N_END_CHAR)) {
            // 将剔除大括号后的字符进行国际化
            return class_2561.method_43471(strIn.substring(1, strIn.length() - 1));
        } else {
            // 否则装填原字符串（这算硬编码么？）
            return class_2561.method_43470(strIn);
        }
    }

    /**
     * 将传入的字符串列表进行国际化
     */
    public static List<class_2561> parse(List<String> strIn) {
        List<class_2561> strOut = Lists.newArrayList();
        for (String str : strIn) {
            strOut.add(parse(str));
        }
        return strOut;
    }

    /**
     * 将 key 列表转换成对应的翻译文本
     */
    public static List<class_2561> keysToTrans(List<String> keys, class_124... formatting) {
        List<class_2561> out = Lists.newArrayList();
        for (String k : keys) {
            out.add(class_2561.method_43471(k).method_27695(formatting));
        }
        return out;
    }
}
