package com.github.tartaricacid.touhoulittlemaid.util;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;

public final class ShapeDraw {
    public static void drawSector(int x, int y, int r, double startAngle, double endAngle, int precision, int color) {
        float alpha = (float) (color >> 24 & 255) / 255.0F;
        float red = (float) (color >> 16 & 255) / 255.0F;
        float green = (float) (color >> 8 & 255) / 255.0F;
        float blue = (float) (color & 255) / 255.0F;

        class_289 tesselator = class_289.method_1348();
        class_287 bufferbuilder = tesselator.method_1349();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        bufferbuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        bufferbuilder.method_22912(x, y, 0).method_22915(red, green, blue, alpha).method_1344();
        double precisionAngle = 2 * Math.PI / precision;
        for (int i = (int) (endAngle / precisionAngle); i >= (int) (startAngle / precisionAngle); i--) {
            bufferbuilder.method_22912(x + r * Math.cos(i * precisionAngle),
                    y + r * Math.sin(i * precisionAngle),
                    0).method_22915(red, green, blue, alpha).method_1344();
        }
        tesselator.method_1350();
        RenderSystem.disableBlend();
    }

    public static void drawCircle(int x, int y, int r, int precision, int color) {
        drawSector(x, y, r, 0, 2 * Math.PI, precision, color);
    }
}
