package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3414;
import net.minecraft.class_5819;

public final class SoundUtil {
    private static final long MORNING_START = 0;
    private static final long MORNING_END = 3000;
    private static final long EVENING_START = 12000;
    private static final long EVENING_END = 15000;

    public static class_3414 environmentSound(EntityMaid maid, class_3414 fallback, float probability) {
        class_1937 world = maid.method_37908();
        class_5819 rand = maid.method_6051();
        class_2338 pos = maid.method_24515();
        long dayTime = world.method_8532();
        class_1959 biome = world.method_23753(pos).comp_349();

        // 差不多早上 6:00 - 9:00
        if (rand.method_43057() < probability && MORNING_START < dayTime && dayTime < MORNING_END) {
            return InitSounds.MAID_MORNING;
        }
        // 差不多下午 6:00 - 9:00
        if (rand.method_43057() < probability && EVENING_START < dayTime && dayTime < EVENING_END) {
            return InitSounds.MAID_NIGHT;
        }
        if (rand.method_43057() < probability && world.method_8419() && isRainBiome(biome, pos)) {
            return InitSounds.MAID_RAIN;
        }
        if (rand.method_43057() < probability && world.method_8419() && isSnowyBiome(biome, pos)) {
            return InitSounds.MAID_SNOW;
        }
        if (rand.method_43057() < probability && biome.method_33599(pos)) {
            return InitSounds.MAID_COLD;
        }
        if (rand.method_43057() < probability && shouldSnowGolemBurn(biome, pos)) {
            return InitSounds.MAID_HOT;
        }
        return fallback;
    }

    public static class_3414 attackSound(EntityMaid maid, class_3414 fallback, float probability) {
        class_5819 rand = maid.method_6051();
        if (rand.method_43057() < probability) {
            return InitSounds.MAID_FIND_TARGET;
        }
        return fallback;
    }

    public static boolean isRainBiome(class_1959 biome, class_2338 pos) {
        return biome.method_48162(pos) == class_1959.class_1963.field_9382 && !shouldSnowGolemBurn(biome, pos);
    }

    public static boolean isSnowyBiome(class_1959 biome, class_2338 pos) {
        return biome.method_48162(pos) == class_1959.class_1963.field_9383;
    }

    private static boolean shouldSnowGolemBurn(class_1959 biome, class_2338 pos) {
        return biome.method_21740(pos) > 1.0F;
    }
}
