package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.response.ResponseChat;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ErrorCode;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;

public class AutoGenSettingCallback extends LLMCallback {
    public AutoGenSettingCallback(MaidAIChatManager chatManager, String message, long waitingChatBubbleId) {
        super(chatManager, message, waitingChatBubbleId);
    }

    @Override
    public void onSuccess(ResponseChat responseChat) {
        String result = responseChat.getChatText();
        if (StringUtils.isBlank(result)) {
            onFailure(null, new Throwable("Error in Response Chat: %s".formatted(responseChat)), ErrorCode.CHAT_TEXT_IS_EMPTY);
            return;
        }
        chatManager.customSetting = result.replaceAll("\n+", "\n\n");
        class_1309 owner = maid.method_35057();
        if (owner instanceof class_1657 player) {
            player.method_43496(class_2561.method_43471("ai.touhou_little_maid.chat.llm.auto_gen_setting").method_27692(class_124.field_1080));
        }
        if (maid.field_6002 instanceof class_3218 serverLevel) {
            MinecraftServer server = serverLevel.method_8503();
            server.method_20493(() -> {
                maid.getChatBubbleManager().removeChatBubble(waitingChatBubbleId);
                maid.getChatBubbleManager().addTextChatBubble("ai.touhou_little_maid.chat.llm.auto_gen_setting");
            });
        }
    }
}