package com.github.tartaricacid.touhoulittlemaid.block;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemHandlerHelper;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.item.ItemFilm;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityShrine;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class BlockShrine extends class_2237 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_265 SHAPE = class_259.method_17786(class_2248.method_9541(0, 0, 0, 16, 5, 16),
            class_2248.method_9541(2, 5, 2, 14, 10, 14),
            class_2248.method_9541(4, 10, 4, 12, 16, 12));

    public BlockShrine() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_9626(class_2498.field_11547).method_9629(2.0F, 3.0F).method_22488());
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING);
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_1268 hand, class_3965 hit) {
        if (hand == class_1268.field_5808 && worldIn.method_8321(pos) instanceof TileEntityShrine shrine) {
            if (playerIn.method_5715()) {
                if (!shrine.isEmpty()) {
                    class_1799 storageItem = shrine.extractStorageItem();
                    ItemHandlerHelper.giveItemToPlayer(playerIn, storageItem);
                    worldIn.method_8396(null, pos, class_3417.field_14770, class_3419.field_15248, 1, 1);
                    return class_1269.field_5812;
                }
                return class_1269.field_5811;
            }
            if (shrine.isEmpty()) {
                if (shrine.canInsert(playerIn.method_6047())) {
                    shrine.insertStorageItem(ItemHandlerHelper.copyStackWithSize(playerIn.method_6047(), 1));
                    playerIn.method_6047().method_7934(1);
                    worldIn.method_8396(null, pos, class_3417.field_14667, class_3419.field_15248, 1, 1);
                    return class_1269.field_5812;
                }
                if (!worldIn.field_9236) {
                    playerIn.method_43496(class_2561.method_43471("message.touhou_little_maid.shrine.not_film"));
                }
                return class_1269.field_5811;
            }
            if (playerIn.method_6047().method_7960()) {
                // 创造模式玩家可以随意复活
                if (!playerIn.method_7337()) {
                    if (playerIn.method_6032() < (playerIn.method_6063() / 2) + 1) {
                        if (!worldIn.field_9236) {
                            playerIn.method_43496(class_2561.method_43471("message.touhou_little_maid.shrine.health_low"));
                        }
                        return class_1269.field_5814;
                    }
                    playerIn.method_6033(0.25f);
                }
                class_1799 film = shrine.getStorageItem();
                ItemFilm.filmToMaid(film, worldIn, pos.method_10084(), playerIn);
                if (playerIn instanceof class_3222 serverPlayer) {
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.SHRINE_REBORN_MAID);
                }
            }
        }
        return super.method_9534(state, worldIn, pos, playerIn, hand, hit);
    }

    @Override
    public void method_9536(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 newState, boolean isMoving) {
        class_2586 blockEntity = worldIn.method_8321(pos);
        if (blockEntity instanceof TileEntityShrine shrine) {
            class_1799 storageItem = shrine.extractStorageItem();
            if (!storageItem.method_7960()) {
                class_2248.method_9577(worldIn, pos.method_10069(0, 1, 0), storageItem);
            }
        }
        super.method_9536(state, worldIn, pos, newState, isMoving);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        return this.method_9564().method_11657(FACING, context.method_8042().method_10153());
    }

    @Override
    public class_2464 method_9604(class_2680 pState) {
        return class_2464.field_11456;
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 blockState) {
        return new TileEntityShrine(pos, blockState);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return SHAPE;
    }
}
