package com.github.tartaricacid.touhoulittlemaid.client.gui.item;

import cn.sh1rocu.touhoulittlemaid.mixin.accessor.ScreenAccessor;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.github.tartaricacid.touhoulittlemaid.network.message.FoxScrollMessage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SetScrollData;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nullable;
import java.util.List;
import java.util.Map;

public class FoxScrollScreen extends class_437 {
    private static final int PER_PAGE_COUNT = 5;
    private final Map<String, List<FoxScrollMessage.FoxScrollData>> data;
    private int leftPos;
    private int topPos;
    private String selectDim;
    private int page = 0;

    public FoxScrollScreen(Map<String, List<FoxScrollMessage.FoxScrollData>> data) {
        super(class_2561.method_43470("Red Fox Scroll"));
        this.data = data;
        if (!this.data.isEmpty()) {
            this.selectDim = this.data.keySet().stream().findFirst().get();
        }
    }

    @Override
    protected void method_25426() {
        this.method_37067();
        this.leftPos = (this.field_22789 - 400) / 2;
        this.topPos = (this.field_22790 - 208) / 2;
        this.addDimensionButtons();
        this.addPointButtons();
    }

    private void addPointButtons() {
        if (StringUtils.isNotBlank(this.selectDim) && this.data.containsKey(this.selectDim)) {
            List<FoxScrollMessage.FoxScrollData> scrollData = this.data.get(this.selectDim);
            if (scrollData.size() > PER_PAGE_COUNT) {
                method_37063(new FlatColorButton(leftPos + 400 - 20, topPos, 20, 20, class_2561.method_43470("↑"), b -> {
                    if (this.page > 0) {
                        this.page--;
                        this.method_25426();
                    }
                }));
                method_37063(new FlatColorButton(leftPos + 400 - 20, topPos + 208 - 20, 20, 20, class_2561.method_43470("↓"), b -> {
                    if (this.page < (scrollData.size() - 1) / PER_PAGE_COUNT) {
                        this.page++;
                        this.method_25426();
                    }
                }));
            }
            int offsetIn = this.topPos;
            for (int i = this.page * PER_PAGE_COUNT; i < this.page * PER_PAGE_COUNT + PER_PAGE_COUNT; i++) {
                if (i < scrollData.size()) {
                    FoxScrollMessage.FoxScrollData info = scrollData.get(i);
                    this.method_37063(new FlatColorButton(leftPos + 400 - 90, offsetIn + 11, 60, 20, class_2561.method_43471("gui.touhou_little_maid.fox_scroll.track"),
                            b -> ClientPlayNetworking.send(SetScrollData.ID, SetScrollData.encode(this.selectDim, info.getPos()))));
                    offsetIn = offsetIn + 42;
                }
            }
        }
    }

    private void addDimensionButtons() {
        int offset = this.topPos;
        for (String dim : this.data.keySet()) {
            class_2561 name = class_2561.method_43470(dim);
            FlatColorButton dimButton = new FlatColorButton(leftPos, offset, 150, 19, name, b -> {
                this.selectDim = dim;
                this.page = 0;
                this.method_25426();
            });
            if (dim.equals(this.selectDim)) {
                dimButton.setSelect(true);
            }
            this.method_37063(dimButton);
            offset = offset + 21;
        }
    }

    @Override
    public void method_25394(class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.method_25420(graphics);
        if (this.data.isEmpty()) {
            int x = this.field_22789 / 2;
            int y = this.field_22790 / 2 - 5;
            graphics.method_27534(field_22793, class_2561.method_43471("gui.touhou_little_maid.fox_scroll.empty"), x, y, 0xFF0000);
            return;
        }
        this.renderMain(graphics);
        for (class_4068 renderable : ((ScreenAccessor) this).tlm$getRenderables()) {
            renderable.method_25394(graphics, pMouseX, pMouseY, pPartialTick);
        }
    }

    private void renderMain(class_332 graphics) {
        if (StringUtils.isNotBlank(this.selectDim) && this.data.containsKey(this.selectDim)) {
            List<FoxScrollMessage.FoxScrollData> scrollData = this.data.get(this.selectDim);
            boolean inSameDim = this.selectDim.equals(this.getPlayerDimension());
            class_2338 playerPos = this.getPlayerPos();
            int offsetIn = this.topPos;
            for (int i = this.page * PER_PAGE_COUNT; i < this.page * PER_PAGE_COUNT + PER_PAGE_COUNT; i++) {
                if (i < scrollData.size()) {
                    FoxScrollMessage.FoxScrollData info = scrollData.get(i);
                    class_2338 pos = info.getPos();
                    class_2561 distanceText;
                    if (inSameDim) {
                        int distance = (int) Math.sqrt(playerPos.method_10262(pos));
                        distanceText = class_2561.method_43469("gui.touhou_little_maid.fox_scroll.distance.same_dimension", distance);
                    } else {
                        distanceText = class_2561.method_43471("gui.touhou_little_maid.fox_scroll.distance.different_dimension");
                    }
                    class_2561 posText = class_2561.method_43469("gui.touhou_little_maid.fox_scroll.position", pos.method_23854());
                    graphics.method_25294(leftPos + 152, offsetIn, leftPos + 400 - 22, offsetIn + 40, 0xef58626b);
                    graphics.method_27535(field_22793, info.getName(), leftPos + 160, offsetIn + 4, class_124.field_1065.method_532());
                    graphics.method_51439(field_22793, posText, leftPos + 160, offsetIn + 16, class_124.field_1080.method_532(), false);
                    graphics.method_51439(field_22793, distanceText, leftPos + 160, offsetIn + 28, class_124.field_1080.method_532(), false);
                    offsetIn = offsetIn + 42;
                }
            }
            if (scrollData.size() > PER_PAGE_COUNT) {
                String pageText = String.format("%d/%d", this.page + 1, (scrollData.size() - 1) / PER_PAGE_COUNT + 1);
                graphics.method_25300(field_22793, pageText, leftPos + 400 - 8, topPos + 104 - 5, class_124.field_1080.method_532());
            }
        }
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    private class_2338 getPlayerPos() {
        if (Screens.getClient(this).field_1724 != null) {
            return Screens.getClient(this).field_1724.method_24515();
        }
        return class_2338.field_10980;
    }

    @Nullable
    private String getPlayerDimension() {
        if (Screens.getClient(this).field_1724 != null) {
            return Screens.getClient(this).field_1724.field_6002.method_27983().method_29177().toString();
        }
        return null;
    }
}
