package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.api.client.gui.ITooltipButton;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

@Environment(EnvType.CLIENT)
public class TaskButton extends class_4185 implements ITooltipButton {
    private final IMaidTask task;
    private final boolean enable;
    private final class_2960 resourceLocation;
    private final int xTexStart;
    private final int yTexStart;
    private final int yDiffTex;
    private final int textureWidth;
    private final int textureHeight;
    private final List<class_2561> tooltips;

    public TaskButton(IMaidTask task, boolean enable, int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, class_2960 resourceLocationIn, class_4241 onPressIn) {
        this(task, enable, xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, 256, 256, onPressIn);
    }

    public TaskButton(IMaidTask task, boolean enable, int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, class_2960 resourceLocationIn, int textureWidth, int textureHeight, class_4241 onPressIn) {
        this(task, enable, xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, textureWidth, textureHeight, onPressIn, class_2561.method_43473());
    }

    public TaskButton(IMaidTask task, boolean enable, int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, class_2960 resourceLocation, int textureWidth, int textureHeight, class_4241 onPress, class_2561 title) {
        this(task, enable, x, y, width, height, xTexStart, yTexStart, yDiffText, resourceLocation, textureWidth, textureHeight, onPress, Collections.emptyList(), title);
    }

    public TaskButton(IMaidTask task, boolean enable, int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, class_2960 resourceLocation, int textureWidth, int textureHeight, class_4241 onPress, List<class_2561> tooltips, class_2561 title) {
        super(x, y, width, height, title, onPress, Supplier::get);
        this.task = task;
        this.enable = enable;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.xTexStart = xTexStart;
        this.yTexStart = yTexStart;
        this.yDiffTex = yDiffText;
        this.resourceLocation = resourceLocation;
        this.tooltips = tooltips;
    }

    public IMaidTask getTask() {
        return task;
    }

    @Override
    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        // 禁用声音
        if (!enable) {
            return false;
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    @Override
    @SuppressWarnings("all")
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        class_310 minecraft = class_310.method_1551();
        int i = this.yTexStart;
        if (this.method_25367()) {
            i += this.yDiffTex;
        }
        RenderSystem.enableDepthTest();
        graphics.method_25290(this.resourceLocation, this.method_46426(), this.method_46427(), (float) this.xTexStart, (float) i, this.field_22758, this.field_22759, this.textureWidth, this.textureHeight);
        if (!enable) {
            // 不知为啥设定渲染高度是19，但渲染出来的是20...
            graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0x80000000);
            graphics.method_25290(this.resourceLocation, this.method_46426() + 72, this.method_46427(), (float) 93, (float) 68, 7, 19, this.textureWidth, this.textureHeight);
        }
        graphics.method_51427(task.getIcon(), this.method_46426() + 2, this.method_46427() + 2);
        graphics.method_51439(minecraft.field_1772, task.getName(), this.method_46426() + 23, this.method_46427() + 6, 0x333333, false);
    }

    @Override
    public boolean isTooltipHovered() {
        return this.method_49606();
    }

    @Override
    public void renderTooltip(class_332 graphics, class_310 mc, int mouseX, int mouseY) {
        if (!this.tooltips.isEmpty()) {
            graphics.method_51434(mc.field_1772, this.tooltips, mouseX, mouseY);
        }
    }
}
