package com.github.tartaricacid.touhoulittlemaid.command.subcommand;

import com.github.tartaricacid.touhoulittlemaid.command.arguments.HandleTypeArgument;
import com.github.tartaricacid.touhoulittlemaid.data.MaidNumAttachment;
import com.google.common.base.Supplier;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2300;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

import static com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment.MAID_NUM;

public final class MaidNumCommand {
    private static final String MAID_NUM_NAME = "maid_num";
    private static final String GET_NAME = "get";
    private static final String HANDLE_NAME = "handle";
    private static final String TARGETS_NAME = "targets";
    private static final String COUNT_NAME = "count";

    public static LiteralArgumentBuilder<class_2168> get() {
        LiteralArgumentBuilder<class_2168> pack = class_2170.method_9247(MAID_NUM_NAME);
        RequiredArgumentBuilder<class_2168, class_2300> targets = class_2170.method_9244(TARGETS_NAME, class_2186.method_9308());
        RequiredArgumentBuilder<class_2168, Integer> count = class_2170.method_9244(COUNT_NAME, IntegerArgumentType.integer(0));
        RequiredArgumentBuilder<class_2168, String> handleType = class_2170.method_9244(HANDLE_NAME, HandleTypeArgument.type());

        pack.then(class_2170.method_9247(GET_NAME).then(targets.executes(MaidNumCommand::getMaidNum)));
        pack.then(handleType.then(targets.then(count.executes(MaidNumCommand::handleMaidNum))));
        return pack;
    }

    private static int handleMaidNum(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection<class_3222> players = class_2186.method_9312(context, TARGETS_NAME);
        int count = IntegerArgumentType.getInteger(context, COUNT_NAME);
        String type = HandleTypeArgument.getType(context, HANDLE_NAME);
        Supplier<MaidNumAttachment> defaultAttach = () -> new MaidNumAttachment(0);
        for (class_1657 player : players) {
            switch (type) {
                case "set":
                    player.getAttachedOrCreate(MAID_NUM, defaultAttach).set(count);
                    break;
                case "add":
                    player.getAttachedOrCreate(MAID_NUM, defaultAttach).add(count);
                    break;
                case "min":
                    player.getAttachedOrCreate(MAID_NUM, defaultAttach).min(count);
                    break;
                default:
            }
        }
        context.getSource().method_9226(() -> class_2561.method_43469("commands.touhou_little_maid.maid_num.handle.info", players.size()), true);
        return Command.SINGLE_SUCCESS;
    }

    private static int getMaidNum(CommandContext<class_2168> context) throws CommandSyntaxException {
        for (class_1657 player : class_2186.method_9312(context, TARGETS_NAME)) {
            MaidNumAttachment numAttachment = player.getAttachedOrCreate(MAID_NUM, () -> new MaidNumAttachment(0));
            context.getSource().method_9226(() -> class_2561.method_43469("commands.touhou_little_maid.maid_num.get.info",
                    player.method_5820(), numAttachment.get()), false);
        }
        return Command.SINGLE_SUCCESS;
    }
}
