package com.github.tartaricacid.touhoulittlemaid.compat.slashblade;

import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.ILocationModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.RenderUtils;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;

@Environment(EnvType.CLIENT)
public class SlashBladeRender {
    private static final class_2960 RESOURCE_DEFAULT_MODEL = new class_2960("slashblade", "model/blade.obj");
    private static final class_2960 RESOURCE_DEFAULT_TEXTURE = new class_2960("slashblade", "model/blade.png");

    public static void renderSlashBlade(class_4587 matrixStack, class_4597 bufferIn, int lightIn, class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        CapabilitySlashBlade.BLADESTATE.maybeGet(stack).ifPresent(bladeState -> {
            class_2960 texture = bladeState.getTexture().orElse(RESOURCE_DEFAULT_TEXTURE);
            WavefrontObject obj = BladeModelManager.getInstance().getModel(bladeState.getModel().orElse(null));
            String part;
            if (bladeState.isBroken()) {
                part = "blade_damaged";
            } else {
                part = "blade";
            }
            BladeRenderState.renderOverrided(stack, obj, part, texture, matrixStack, bufferIn, lightIn);
            BladeRenderState.renderOverridedLuminous(stack, obj, part + "_luminous", texture, matrixStack, bufferIn, lightIn);
            BladeRenderState.renderOverrided(stack, obj, "sheath", texture, matrixStack, bufferIn, lightIn);
            BladeRenderState.renderOverridedLuminous(stack, obj, "sheath_luminous", texture, matrixStack, bufferIn, lightIn);
        });
    }

    public static void renderMaidBackSlashBlade(class_4587 matrixStack, class_4597 bufferIn, int lightIn, class_1799 stack) {
        matrixStack.method_22904(0.9, -0.25, 0.05);
        matrixStack.method_22907(class_7833.field_40717.rotationDegrees(15));
        matrixStack.method_22905(0.007F, 0.007F, 0.007F);
        renderSlashBlade(matrixStack, bufferIn, lightIn, stack);
    }

    public static void renderGeckoMaidBackSlashBlade(class_4587 matrixStack, class_4597 bufferIn, int lightIn, class_1799 stack) {
        matrixStack.method_22904(1.25, -0.25, 0);
        matrixStack.method_22907(class_7833.field_40717.rotationDegrees(15));
        matrixStack.method_22905(0.01F, 0.01F, 0.01F);
        renderSlashBlade(matrixStack, bufferIn, lightIn, stack);
    }

    public static void renderMaidMainhandSlashBlade(class_1308 maid, BedrockModel<class_1308> model, class_4587 matrixStack, class_4597 bufferIn, int lightIn, class_1799 stack, float partialTicks) {
        if (stack.method_7909() instanceof ItemSlashBlade) {
            matrixStack.method_22903();
            // 主手的刀渲染在左边
            if (model.hasWaistPositioningModel(class_1306.field_6182)) {
                model.translateToPositioningWaist(class_1306.field_6182, matrixStack);
            } else {
                matrixStack.method_22904(0.25, 0.85, 0);
                matrixStack.method_22907(class_7833.field_40714.rotationDegrees(-20));
            }
            matrixStack.method_22904(0, 0, -0.5);
            matrixStack.method_22905(0.007F, 0.007F, 0.007F);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(90));
            if (stack.method_7960()) {
                return;
            }
            CapabilitySlashBlade.BLADESTATE.maybeGet(stack).ifPresent(bladeState -> {
                class_2960 texture = bladeState.getTexture().orElse(RESOURCE_DEFAULT_TEXTURE);
                WavefrontObject obj = BladeModelManager.getInstance().getModel(bladeState.getModel().orElse(RESOURCE_DEFAULT_MODEL));
                String part;
                if (bladeState.isBroken()) {
                    part = "blade_damaged";
                } else {
                    part = "blade";
                }
                BladeRenderState.renderOverrided(stack, obj, "sheath", texture, matrixStack, bufferIn, lightIn);
                BladeRenderState.renderOverridedLuminous(stack, obj, "sheath_luminous", texture, matrixStack, bufferIn, lightIn);
                long time = maid.field_6002.method_8510() - bladeState.getLastActionTime();
                if (time < 5) {
                    float i = time + partialTicks;
                    matrixStack.method_22904(0, 0, -0.5 / 0.007);
                    matrixStack.method_22907(class_7833.field_40716.rotationDegrees(60 + i * 48));
                    matrixStack.method_22907(class_7833.field_40714.rotationDegrees(90));
                }
                BladeRenderState.renderOverrided(stack, obj, part, texture, matrixStack, bufferIn, lightIn);
                BladeRenderState.renderOverridedLuminous(stack, obj, part + "_luminous", texture, matrixStack, bufferIn, lightIn);
            });
            matrixStack.method_22909();
        }
    }

    public static void renderMaidMainhandSlashBlade(class_1309 maid, ILocationModel model, class_4587 matrixStack, class_4597 bufferIn, int lightIn, class_1799 stack, float partialTicks) {
        if (stack.method_7909() instanceof ItemSlashBlade) {
            matrixStack.method_22903();
            // 主手的刀渲染在左边
            if (!model.leftWaistBones().isEmpty()) {
                translateToWaist(class_1306.field_6182, matrixStack, model);
            } else {
                matrixStack.method_22904(-0.25, 1.25, 0);
                matrixStack.method_22907(class_7833.field_40714.rotationDegrees(20));
            }
            matrixStack.method_22904(0, 0, -0.7);
            matrixStack.method_22905(0.01F, 0.01F, 0.01F);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-90));
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees(180));
            if (stack.method_7960()) {
                return;
            }
            CapabilitySlashBlade.BLADESTATE.maybeGet(stack).ifPresent(bladeState -> {
                class_2960 texture = bladeState.getTexture().orElse(RESOURCE_DEFAULT_TEXTURE);
                WavefrontObject obj = BladeModelManager.getInstance().getModel(bladeState.getModel().orElse(RESOURCE_DEFAULT_MODEL));
                String part;
                if (bladeState.isBroken()) {
                    part = "blade_damaged";
                } else {
                    part = "blade";
                }
                BladeRenderState.renderOverrided(stack, obj, "sheath", texture, matrixStack, bufferIn, lightIn);
                BladeRenderState.renderOverridedLuminous(stack, obj, "sheath_luminous", texture, matrixStack, bufferIn, lightIn);
                long time = maid.field_6002.method_8510() - bladeState.getLastActionTime();
                if (time < 5) {
                    float i = time + partialTicks;
                    matrixStack.method_22904(0, 0, -0.5 / 0.007);
                    matrixStack.method_22907(class_7833.field_40716.rotationDegrees(60 + i * 48));
                    matrixStack.method_22907(class_7833.field_40714.rotationDegrees(90));
                }
                BladeRenderState.renderOverrided(stack, obj, part, texture, matrixStack, bufferIn, lightIn);
                BladeRenderState.renderOverridedLuminous(stack, obj, part + "_luminous", texture, matrixStack, bufferIn, lightIn);
            });
            matrixStack.method_22909();
        }
    }

    public static void renderMaidOffhandSlashBlade(BedrockModel<?> model, class_4587 matrixStack, class_4597 bufferIn, int lightIn, class_1799 stack) {
        if (stack.method_7909() instanceof ItemSlashBlade) {
            matrixStack.method_22903();
            // 副手的刀渲染在右边
            if (model.hasWaistPositioningModel(class_1306.field_6183)) {
                model.translateToPositioningWaist(class_1306.field_6183, matrixStack);
            } else {
                matrixStack.method_22904(-0.25, 0.85, 0);
                matrixStack.method_22907(class_7833.field_40714.rotationDegrees(-5));
            }
            matrixStack.method_22904(0, 0, -0.5);
            matrixStack.method_22905(0.007F, 0.007F, 0.007F);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(90));
            SlashBladeRender.renderSlashBlade(matrixStack, bufferIn, lightIn, stack);
            matrixStack.method_22909();
        }
    }

    public static void renderMaidOffhandSlashBlade(ILocationModel model, class_4587 matrixStack, class_4597 bufferIn, int lightIn, class_1799 stack) {
        if (stack.method_7909() instanceof ItemSlashBlade) {
            matrixStack.method_22903();
            // 副手的刀渲染在右边
            if (!model.rightWaistBones().isEmpty()) {
                translateToWaist(class_1306.field_6183, matrixStack, model);
            } else {
                matrixStack.method_22904(0.25, 1.25, 0);
                matrixStack.method_22907(class_7833.field_40714.rotationDegrees(5));
            }
            matrixStack.method_22904(0, 0, -0.7);
            matrixStack.method_22905(0.01F, 0.01F, 0.01F);
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-90));
            matrixStack.method_22907(class_7833.field_40718.rotationDegrees(180));
            SlashBladeRender.renderSlashBlade(matrixStack, bufferIn, lightIn, stack);
            matrixStack.method_22909();
        }
    }

    private static void translateToWaist(class_1306 arm, class_4587 poseStack, ILocationModel geoModel) {
        if (arm == class_1306.field_6182) {
            RenderUtils.prepMatrixForLocator(poseStack, geoModel.leftWaistBones());
        } else {
            RenderUtils.prepMatrixForLocator(poseStack, geoModel.rightWaistBones());
        }
    }
}