package com.github.tartaricacid.touhoulittlemaid.datagen.advancement;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;


public class FavorabilityAdvancement {
    public static void generate(Consumer<class_161> saver) {
        class_161 root = make(InitItems.BOOKSHELF, "maid_sit_joy")
                .method_709("maid_event", MaidEventTrigger.create(TriggerType.MAID_SIT_JOY))
                .method_703(class_170.class_171.method_750(50))
                .method_694(saver, id("favorability/maid_sit_joy").toString());

        generateFavorability(saver, root);

        generateJoy(saver, root);
    }

    private static void generateJoy(Consumer<class_161> saver, class_161 root) {
        class_161 joy = make(InitItems.PICNIC_BASKET, "maid_picnic_eat").method_701(root)
                .method_709("maid_event", MaidEventTrigger.create(TriggerType.MAID_PICNIC_EAT))
                .method_694(saver, id("favorability/maid_picnic_eat").toString());

        class_161 gomoku = makeGoal(InitItems.GOMOKU, "win_gomoku").method_701(joy)
                .method_709("maid_event", MaidEventTrigger.create(TriggerType.WIN_GOMOKU))
                .method_694(saver, id("favorability/win_gomoku").toString());

        class_161 cchess = makeGoal(InitItems.CCHESS, "win_cchess").method_701(gomoku)
                .method_709("maid_event", MaidEventTrigger.create(TriggerType.WIN_CCHESS))
                .method_694(saver, id("favorability/win_cchess").toString());

        makeGoal(InitItems.WCHESS, "win_wchess").method_701(cchess)
                .method_709("maid_event", MaidEventTrigger.create(TriggerType.WIN_WCHESS))
                .method_694(saver, id("favorability/win_wchess").toString());

        make(InitItems.MAID_BED, "maid_sleep").method_701(joy)
                .method_709("maid_event", MaidEventTrigger.create(TriggerType.MAID_SLEEP))
                .method_694(saver, id("favorability/maid_sleep").toString());
    }

    private static void generateFavorability(Consumer<class_161> saver, class_161 root) {
        class_161 increased = make(InitItems.FAVORABILITY_TOOL_ADD, "favorability_increased").method_701(root)
                .method_709("maid_event", MaidEventTrigger.create(TriggerType.FAVORABILITY_INCREASED))
                .method_694(saver, id("favorability/favorability_increased").toString());

        makeGoal(InitItems.FAVORABILITY_TOOL_FULL, "favorability_increased_max").method_701(increased)
                .method_709("maid_event", MaidEventTrigger.create(TriggerType.FAVORABILITY_INCREASED_MAX))
                .method_694(saver, id("favorability/favorability_increased_max").toString());
    }

    private static class_161.class_162 make(class_1935 item, String key) {
        class_5250 title = class_2561.method_43471(String.format("advancements.touhou_little_maid.favorability.%s.title", key));
        class_5250 desc = class_2561.method_43471(String.format("advancements.touhou_little_maid.favorability.%s.description", key));

        return class_161.class_162.method_707().method_697(item, title, desc,
                new class_2960(TouhouLittleMaid.MOD_ID, "textures/advancements/backgrounds/stone.png"),
                class_189.field_1254, true, true, false);
    }

    private static class_161.class_162 makeGoal(class_1935 item, String key) {
        class_5250 title = class_2561.method_43471(String.format("advancements.touhou_little_maid.favorability.%s.title", key));
        class_5250 desc = class_2561.method_43471(String.format("advancements.touhou_little_maid.favorability.%s.description", key));

        return class_161.class_162.method_707().method_697(item, title, desc,
                new class_2960(TouhouLittleMaid.MOD_ID, "textures/advancements/backgrounds/stone.png"),
                class_189.field_1249, true, true, false);
    }

    private static class_2960 id(String id) {
        return new class_2960(TouhouLittleMaid.MOD_ID, id);
    }
}
