package com.github.tartaricacid.touhoulittlemaid.entity.misc;

import com.mojang.serialization.Codec;
import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import net.minecraft.class_5250;

public enum MonsterType implements class_3542 {
    FRIENDLY,
    NEUTRAL,
    HOSTILE;

    public static final Codec<MonsterType> CODEC = class_3542.method_28140(MonsterType::values);

    private final class_5250 component;

    MonsterType() {
        this.component = class_2561.method_43471("gui.touhou_little_maid.monster_type." + this.name().toLowerCase(Locale.ENGLISH));
    }

    public MonsterType getPrevious() {
        int index = this.ordinal() - 1;
        if (index < 0) {
            index = values().length - 1;
        }
        return values()[index % values().length];
    }

    public MonsterType getNext() {
        int ordinal = this.ordinal();
        int length = MonsterType.values().length;
        return MonsterType.values()[(ordinal + 1) % length];
    }

    public class_5250 getComponent() {
        return component;
    }

    @Override
    public String method_15434() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }
}