package com.github.tartaricacid.touhoulittlemaid.inventory.container.config;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.site.ClientAvailableSitesSync;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nullable;
import java.util.Map;

public class MaidAIChatConfigContainer extends AbstractMaidContainer {
    public static final class_3917<MaidAIChatConfigContainer> TYPE = new ExtendedScreenHandlerType<>(MaidAIChatConfigContainer::create);

    private static final int PLAYER_INVENTORY_SIZE = 27;

    private final class_2487 configData;
    private final Map<String, Map<String, String>> llmSites;
    private final Map<String, Map<String, String>> ttsSites;

    public MaidAIChatConfigContainer(int id, class_1661 inventory, int entityId,
                                     @Nullable class_2487 configData,
                                     Map<String, Map<String, String>> llmSites,
                                     Map<String, Map<String, String>> ttsSites) {
        super(TYPE, id, inventory, entityId);
        this.configData = configData;
        this.llmSites = llmSites;
        this.ttsSites = ttsSites;
    }

    public static class_3908 create(EntityMaid maid) {
        return new ExtendedScreenHandlerFactory() {
            @Override
            public @NotNull class_2561 method_5476() {
                return class_2561.method_43470("Maid AI Chat Config Container");
            }

            @Override
            public class_1703 createMenu(int index, @NotNull class_1661 playerInventory, @NotNull class_1657 player) {
                int entityId = maid.method_5628();
                class_2487 configData = maid.getAiChatManager().writeToTag(new class_2487());
                return new MaidAIChatConfigContainer(index, playerInventory, entityId, configData,
                        ClientAvailableSitesSync.getClientLLMSites(),
                        ClientAvailableSitesSync.getClientTTSSites());
            }

            @Override
            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                int entityId = maid.method_5628();
                class_2487 configData = maid.getAiChatManager().writeToTag(new class_2487());
                buf.writeInt(entityId);
                buf.method_10794(configData);
                ClientAvailableSitesSync.writeToNetwork(buf);
            }

            @Override
            public boolean shouldCloseCurrentScreen() {
                return false;
            }

/*            @Override
            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return false;
            }*/
        };
    }

    @NotNull
    private static MaidAIChatConfigContainer create(int windowId, class_1661 inv, class_2540 buf) {
        int entityId = buf.readInt();
        class_2487 configData = buf.method_10798();
        var sites = ClientAvailableSitesSync.readFromNetwork(buf);
        return new MaidAIChatConfigContainer(windowId, inv, entityId, configData, sites.getLeft(), sites.getRight());
    }

    public class_2487 getConfigData() {
        return configData;
    }

    public Map<String, Map<String, String>> getLLMSites() {
        return llmSites;
    }

    public Map<String, Map<String, String>> getTTSSites() {
        return ttsSites;
    }

    @Override
    public class_1799 method_7601(class_1657 playerIn, int index) {
        class_1799 stack1 = class_1799.field_8037;
        class_1735 slot = this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 stack2 = slot.method_7677();
            stack1 = stack2.method_7972();
            if (index < PLAYER_INVENTORY_SIZE) {
                if (!this.method_7616(stack2, PLAYER_INVENTORY_SIZE, this.field_7761.size(), false)) {
                    return class_1799.field_8037;
                }
            } else if (!this.method_7616(stack2, 0, PLAYER_INVENTORY_SIZE, true)) {
                return class_1799.field_8037;
            }
            if (stack2.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return stack1;
    }
}