package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.data.MaidNumAttachment;
import com.github.tartaricacid.touhoulittlemaid.data.PowerAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.getResourceLocation;

public class StorageAndTakePowerMessage {
    public static final class_2960 ID = getResourceLocation("save_and_take_power");

    public static class_2540 encode(class_2338 pos, float powerNum, boolean isStorage) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pos);
        buf.writeFloat(powerNum);
        buf.writeBoolean(isStorage);
        return buf;
    }

    public static void handle(MinecraftServer server, class_3222 sender, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        class_2338 pos = buf.method_10811();
        float powerNum = buf.readFloat();
        boolean isStorage = buf.readBoolean();
        server.execute(() -> {
            class_1937 world = sender.method_37908();
            if (world.method_8477(pos)) {
                class_2586 te = world.method_8321(pos);
                if (te instanceof TileEntityMaidBeacon beacon) {
                    PowerAttachment power = sender.getAttachedOrCreate(InitDataAttachment.POWER_NUM);
                    MaidNumAttachment maidNum = sender.getAttachedOrCreate(InitDataAttachment.MAID_NUM);
                    if (isStorage) {
                        storageLogic(powerNum, power, beacon);
                    } else {
                        takeLogic(powerNum, power, beacon);
                    }

                    ServerPlayNetworking.send(sender, SyncDataMessage.ID, SyncDataMessage.encode(power.get(), maidNum.get()));
                }
            }
        });
    }

    private static void storageLogic(float powerNum, PowerAttachment playerPower, TileEntityMaidBeacon beacon) {
        boolean playerPowerIsEnough = powerNum <= playerPower.get();
        boolean beaconNotFull = powerNum + beacon.getStoragePower() <= beacon.getMaxStorage();
        if (playerPowerIsEnough) {
            if (beaconNotFull) {
                playerPower.min(powerNum);
                beacon.setStoragePower(beacon.getStoragePower() + powerNum);
            } else {
                playerPower.min(beacon.getMaxStorage() - beacon.getStoragePower());
                beacon.setStoragePower(beacon.getMaxStorage());
            }
        }
    }

    private static void takeLogic(float powerNum, PowerAttachment playerPower, TileEntityMaidBeacon beacon) {
        boolean beaconIsEnough = powerNum <= beacon.getStoragePower();
        boolean playerNotFull = powerNum + playerPower.get() < PowerAttachment.MAX_POWER;
        if (beaconIsEnough) {
            if (playerNotFull) {
                beacon.setStoragePower(beacon.getStoragePower() - powerNum);
                playerPower.add(powerNum);
            } else {
                beacon.setStoragePower(beacon.getStoragePower() - PowerAttachment.MAX_POWER + playerPower.get());
                playerPower.set(PowerAttachment.MAX_POWER);
            }
        }
    }

}
