/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.config;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatManager;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.site.AvailableSites;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.STTApiType;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.SupportLanguage;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai.HistoryAIChatScreen;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai.SettingEditScreen;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MaidAIChatConfigButton;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.config.MaidAIChatConfigContainer;
import com.github.tartaricacid.touhoulittlemaid.network.message.SaveMaidAIDataMessage;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_1661;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNGuiHints;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;
import org.apache.commons.lang3.StringUtils;

@IPNPlayerSideOnly
@IPNGuiHints(value={@IPNGuiHint(button=IPNButton.SORT, horizontalOffset=-36, bottom=-12), @IPNGuiHint(button=IPNButton.SORT_COLUMNS, horizontalOffset=-24, bottom=-24), @IPNGuiHint(button=IPNButton.SORT_ROWS, horizontalOffset=-12, bottom=-36), @IPNGuiHint(button=IPNButton.SHOW_EDITOR, horizontalOffset=-5), @IPNGuiHint(button=IPNButton.SETTINGS, horizontalOffset=-5)})
public class MaidAIChatConfigContainerGui
extends AbstractMaidContainerGui<MaidAIChatConfigContainer> {
    private static final class_2960 ICON = new class_2960("touhou_little_maid", "textures/gui/maid_ai_chat_config.png");
    private final MaidAIChatManager manager;
    private final Map<String, Map<String, String>> llmSites;
    private final Map<String, Map<String, String>> ttsSites;
    private final List<String> sttSites = Lists.newArrayList(AvailableSites.STT_SITES.keySet());

    public MaidAIChatConfigContainerGui(MaidAIChatConfigContainer screenContainer, class_1661 inv, class_2561 titleIn) {
        super(screenContainer, inv, titleIn);
        this.maid.getAiChatManager().readFromTag(screenContainer.getConfigData());
        this.manager = this.maid.getAiChatManager();
        this.llmSites = screenContainer.getLLMSites();
        this.ttsSites = screenContainer.getTTSSites();
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTicks, int x, int y) {
        super.method_2389(graphics, partialTicks, x, y);
        graphics.method_25302(ICON, this.field_2776 + 80, this.field_2800 + 28, 0, 0, 176, 137);
    }

    @Override
    protected void initAdditionWidgets() {
        int buttonLeft = this.field_2776 + 86;
        int buttonTop = this.field_2800 + 38;
        this.addConfigButtons(buttonLeft, buttonTop);
        this.addOtherButtons(buttonLeft);
    }

    private void addOtherButtons(int buttonLeft) {
        class_5250 edit = class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.edit");
        class_5250 history = class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.open_history_chat");
        this.method_37063((class_364)class_4185.method_46430((class_2561)edit, button -> {
            this.method_25426();
            this.saveConfig();
            Screens.getClient((class_437)this).method_1507((class_437)new SettingEditScreen(this.maid));
        }).method_46434(buttonLeft + 2, this.field_2800 + 120, 160, 18).method_46436(class_7919.method_47407((class_2561)edit)).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)history, button -> {
            this.saveConfig();
            Screens.getClient((class_437)this).method_1507((class_437)new HistoryAIChatScreen(this.maid));
        }).method_46434(buttonLeft + 2, this.field_2800 + 140, 160, 18).method_46436(class_7919.method_47407((class_2561)history)).method_46431());
    }

    private void addConfigButtons(int buttonLeft, int buttonTop) {
        class_5250 noSiteSelectedName = class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.no_site_selected");
        class_5250 llmSiteName = class_2561.method_43470((String)this.manager.llmSite);
        class_5250 ttsSiteName = class_2561.method_43470((String)this.manager.ttsSite);
        this.method_37063((class_364)new MaidAIChatConfigButton(buttonLeft, buttonTop, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.llm_site"), (class_2561)(this.manager.llmSite.isBlank() ? noSiteSelectedName : llmSiteName), button -> {
            this.manager.llmSite = this.onClickSites(this.llmSites, this.manager.llmSite, button, true);
            this.method_25426();
            this.saveConfig();
        }, button -> {
            this.manager.llmSite = this.onClickSites(this.llmSites, this.manager.llmSite, button, false);
            this.method_25426();
            this.saveConfig();
        }));
        buttonTop += 13;
        Map<String, String> llmModels = this.llmSites.get(this.manager.llmSite);
        if (llmModels != null && !llmModels.isEmpty()) {
            String name = llmModels.get(this.manager.llmModel);
            if (StringUtils.isBlank((CharSequence)name)) {
                this.manager.llmModel = llmModels.keySet().iterator().next();
                name = llmModels.get(this.manager.llmModel);
            }
            this.method_37063((class_364)new MaidAIChatConfigButton(buttonLeft, buttonTop, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.llm_model"), (class_2561)class_2561.method_43470((String)name), button -> {
                this.manager.llmModel = this.onClickModels(llmModels, this.manager.llmModel, button, true);
                this.saveConfig();
            }, button -> {
                this.manager.llmModel = this.onClickModels(llmModels, this.manager.llmModel, button, false);
                this.saveConfig();
            }));
            buttonTop += 13;
        }
        this.method_37063((class_364)new MaidAIChatConfigButton(buttonLeft, buttonTop, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.tts_site"), (class_2561)(this.manager.ttsSite.isBlank() ? noSiteSelectedName : ttsSiteName), button -> {
            this.manager.ttsSite = this.onClickSites(this.ttsSites, this.manager.ttsSite, button, true);
            this.method_25426();
            this.saveConfig();
        }, button -> {
            this.manager.ttsSite = this.onClickSites(this.ttsSites, this.manager.ttsSite, button, false);
            this.method_25426();
            this.saveConfig();
        }));
        buttonTop += 13;
        Map<String, String> ttsModels = this.ttsSites.get(this.manager.ttsSite);
        if (ttsModels != null && !ttsModels.isEmpty()) {
            String name = ttsModels.get(this.manager.ttsModel);
            if (StringUtils.isBlank((CharSequence)name)) {
                this.manager.ttsModel = ttsModels.keySet().iterator().next();
                name = ttsModels.get(this.manager.ttsModel);
            }
            this.method_37063((class_364)new MaidAIChatConfigButton(buttonLeft, buttonTop, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.tts_model"), (class_2561)class_2561.method_43470((String)name), button -> {
                this.manager.ttsModel = this.onClickModels(ttsModels, this.manager.ttsModel, button, true);
                this.saveConfig();
            }, button -> {
                this.manager.ttsModel = this.onClickModels(ttsModels, this.manager.ttsModel, button, false);
                this.saveConfig();
            }));
            buttonTop += 13;
        }
        if (StringUtils.isBlank((CharSequence)this.manager.ttsLanguage)) {
            this.manager.ttsLanguage = SupportLanguage.SUPPORTED_LANGUAGES.get(0);
        }
        this.method_37063((class_364)new MaidAIChatConfigButton(buttonLeft, buttonTop, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.tts_language"), SupportLanguage.getLanguageName(this.manager.ttsLanguage), button -> {
            this.manager.ttsLanguage = SupportLanguage.findPrev(this.manager.ttsLanguage);
            button.setValue(SupportLanguage.getLanguageName(this.manager.ttsLanguage));
            this.saveConfig();
        }, button -> {
            this.manager.ttsLanguage = SupportLanguage.findNext(this.manager.ttsLanguage);
            button.setValue(SupportLanguage.getLanguageName(this.manager.ttsLanguage));
            this.saveConfig();
        }));
        this.addSttButtons(buttonLeft, buttonTop += 13);
    }

    private void addSttButtons(int buttonLeft, int buttonTop) {
        String sttType = ((STTApiType)((Object)AIConfig.STT_TYPE.get())).getName();
        if (this.sttSites.isEmpty()) {
            sttType = "";
        } else if (!this.sttSites.contains(sttType)) {
            sttType = this.sttSites.get(0);
        }
        String finalSttType = sttType;
        this.method_37063((class_364)new MaidAIChatConfigButton(buttonLeft, buttonTop, (class_2561)class_2561.method_43471((String)"config.touhou_little_maid.global_ai.stt_type"), (class_2561)class_2561.method_43470((String)sttType), button -> {
            if (this.sttSites.isEmpty()) {
                return;
            }
            int index = this.sttSites.indexOf(finalSttType);
            if (index != -1) {
                if (--index < 0) {
                    index = this.sttSites.size() - 1;
                }
                AIConfig.STT_TYPE.set((Object)STTApiType.getByName(this.sttSites.get(index)));
            } else {
                AIConfig.STT_TYPE.set((Object)STTApiType.PLAYER2);
            }
            button.setValue((class_2561)class_2561.method_43470((String)((STTApiType)((Object)((Object)AIConfig.STT_TYPE.get()))).getName()));
            this.method_25426();
        }, button -> {
            if (this.sttSites.isEmpty()) {
                return;
            }
            int index = this.sttSites.indexOf(finalSttType);
            if (index != -1) {
                if (++index >= this.sttSites.size()) {
                    index = 0;
                }
                AIConfig.STT_TYPE.set((Object)STTApiType.getByName(this.sttSites.get(index)));
            } else {
                AIConfig.STT_TYPE.set((Object)STTApiType.PLAYER2);
            }
            button.setValue((class_2561)class_2561.method_43470((String)((STTApiType)((Object)((Object)AIConfig.STT_TYPE.get()))).getName()));
            this.method_25426();
        }));
    }

    private String onClickSites(Map<String, Map<String, String>> sites, String site, MaidAIChatConfigButton button, boolean isLeft) {
        if (sites.isEmpty()) {
            button.setValue((class_2561)class_2561.method_43473());
            return "";
        }
        ArrayList keys = Lists.newArrayList(sites.keySet());
        if (keys.size() == 1) {
            button.setValue((class_2561)class_2561.method_43470((String)((String)keys.get(0))));
            return (String)keys.get(0);
        }
        int index = keys.indexOf(site);
        if (index < 0) {
            button.setValue((class_2561)class_2561.method_43470((String)((String)keys.get(0))));
            return (String)keys.get(0);
        }
        if (isLeft) {
            if (--index < 0) {
                index = keys.size() - 1;
            }
        } else if (++index >= keys.size()) {
            index = 0;
        }
        String id = (String)keys.get(index);
        button.setValue((class_2561)class_2561.method_43470((String)id));
        return id;
    }

    private String onClickModels(Map<String, String> models, String model, MaidAIChatConfigButton button, boolean isLeft) {
        if (models.isEmpty()) {
            button.setValue((class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.default_model"));
            return "";
        }
        ArrayList keys = Lists.newArrayList(models.keySet());
        if (keys.size() == 1) {
            String id = (String)keys.get(0);
            button.setValue((class_2561)class_2561.method_43470((String)models.get(id)));
            return id;
        }
        int index = keys.indexOf(model);
        if (index < 0) {
            String id = (String)keys.get(0);
            button.setValue((class_2561)class_2561.method_43470((String)models.get(id)));
            return id;
        }
        if (isLeft) {
            if (--index < 0) {
                index = keys.size() - 1;
            }
        } else if (++index >= keys.size()) {
            index = 0;
        }
        String id = (String)keys.get(index);
        button.setValue((class_2561)class_2561.method_43470((String)models.get(id)));
        return id;
    }

    private void saveConfig() {
        ClientPlayNetworking.send((class_2960)SaveMaidAIDataMessage.ID, (class_2540)SaveMaidAIDataMessage.encode(this.maid.method_5628(), this.manager));
    }
}

