/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_4099;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public abstract class MaidMoveToBlockTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 120;
    private final float movementSpeed;
    private final int verticalSearchRange;
    protected int verticalSearchStart;
    private class_2338 currentWorkPos;

    public MaidMoveToBlockTask(float movementSpeed) {
        this(movementSpeed, 1);
    }

    public MaidMoveToBlockTask(float movementSpeed, int verticalSearchRange) {
        this((Map<class_4140<?>, class_4141>)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18457, InitEntities.TARGET_POS, (Object)class_4141.field_18457), movementSpeed, verticalSearchRange);
    }

    public MaidMoveToBlockTask(Map<class_4140<?>, class_4141> requiredMemoryStateIn, float movementSpeed, int verticalSearchRange) {
        super(requiredMemoryStateIn);
        this.movementSpeed = movementSpeed;
        this.verticalSearchRange = verticalSearchRange;
        this.setMaxCheckRate(120);
    }

    protected final void searchForDestination(class_3218 worldIn, EntityMaid maid) {
        MaidPathFindingBFS pathFinding = this.getOrCreateArrivalMap(worldIn, maid);
        class_2338 centrePos = this.getWorkSearchPos(maid);
        int searchRange = (int)maid.method_18413();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        int y = this.verticalSearchStart;
        while (y <= this.verticalSearchRange) {
            for (int i = 0; i < searchRange; ++i) {
                int x = 0;
                while (x <= i) {
                    int z;
                    int n = z = x < i && x > -i ? i : 0;
                    while (z <= i) {
                        mutableBlockPos.method_25504((class_2382)centrePos, x, y - 1, z);
                        if (maid.method_18407((class_2338)mutableBlockPos) && this.shouldMoveTo(worldIn, maid, (class_2338)mutableBlockPos) && this.checkPathReach(maid, pathFinding, (class_2338)mutableBlockPos) && this.checkOwnerPos(maid, (class_2338)mutableBlockPos)) {
                            class_4215.method_24561((class_1309)maid, (class_2338)mutableBlockPos, (float)this.movementSpeed, (int)0);
                            maid.method_18868().method_18878(InitEntities.TARGET_POS, (Object)new class_4099((class_2338)mutableBlockPos));
                            this.currentWorkPos = mutableBlockPos;
                            this.setNextCheckTickCount(5);
                            this.clearCurrentArrivalMap(pathFinding);
                            return;
                        }
                        z = z > 0 ? -z : 1 - z;
                    }
                    x = x > 0 ? -x : 1 - x;
                }
            }
            y = y > 0 ? -y : 1 - y;
        }
        this.currentWorkPos = null;
        this.clearCurrentArrivalMap(pathFinding);
    }

    protected void clearCurrentArrivalMap(MaidPathFindingBFS pathFinding) {
        pathFinding.finish();
    }

    protected MaidPathFindingBFS getOrCreateArrivalMap(class_3218 worldIn, EntityMaid maid) {
        return new MaidPathFindingBFS(maid.method_5942().method_6342(), worldIn, maid);
    }

    private class_2338 getWorkSearchPos(EntityMaid maid) {
        if (maid.method_18410()) {
            if (this.currentWorkPos != null && maid.method_18407(this.currentWorkPos)) {
                return this.currentWorkPos;
            }
            return maid.method_18412();
        }
        return maid.method_24515();
    }

    private boolean checkOwnerPos(EntityMaid maid, class_2338 mutableBlockPos) {
        if (maid.isHomeModeEnable()) {
            return true;
        }
        return maid.method_35057() != null && mutableBlockPos.method_19769((class_2374)maid.method_35057().method_19538(), 8.0);
    }

    protected abstract boolean shouldMoveTo(class_3218 var1, EntityMaid var2, class_2338 var3);

    @Deprecated(forRemoval=true)
    protected boolean checkPathReach(EntityMaid maid, class_2338 pos) {
        return maid.canPathReach(pos);
    }

    protected boolean checkPathReach(EntityMaid maid, MaidPathFindingBFS pathFinding, class_2338 pos) {
        return pathFinding.canPathReach(pos);
    }
}

