/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidDamageEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleManager;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement.TextChatBubbleData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.tartaricacid.touhoulittlemaid.util.GetJarResources;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_4168;
import net.minecraft.class_5250;

public final class RandomEmoji {
    private static final String FILE_PATH = String.format("/assets/%s/tlm_custom_pack/random_emoji.jsonc", "touhou_little_maid");
    private static final Gson GSON = new Gson();
    private static final String CORE = "core";
    private static final String WORK = "work";
    private static final String IDLE = "idle";
    private static final String SLEEP = "sleep";
    private static final String HURT = "hurt";
    private static final int CHECK_RATE = 1200;
    private static Map<String, String[]> EMOJI_MAP = Maps.newHashMap();

    static void init() {
        try (InputStream stream = GetJarResources.readTouhouLittleMaidFile(FILE_PATH);){
            if (stream != null) {
                EMOJI_MAP = (Map)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), new TypeToken<Map<String, String[]>>(){}.getType());
                String[] core = EMOJI_MAP.get(CORE);
                if (core != null) {
                    String[] idle;
                    String[] work = EMOJI_MAP.get(WORK);
                    if (work != null) {
                        String[] newWork = new String[core.length + work.length];
                        System.arraycopy(core, 0, newWork, 0, core.length);
                        System.arraycopy(work, 0, newWork, core.length, work.length);
                        EMOJI_MAP.put(WORK, newWork);
                    }
                    if ((idle = EMOJI_MAP.get(IDLE)) != null) {
                        String[] newIdle = new String[core.length + idle.length];
                        System.arraycopy(core, 0, newIdle, 0, core.length);
                        System.arraycopy(idle, 0, newIdle, core.length, idle.length);
                        EMOJI_MAP.put(IDLE, newIdle);
                    }
                    EMOJI_MAP.remove(CORE);
                }
                EMOJI_MAP = ImmutableMap.copyOf(EMOJI_MAP);
            }
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Failed to load random emoji json file: {}", (Object)FILE_PATH, (Object)e);
        }
    }

    static void tick(EntityMaid maid) {
        long offset = maid.method_5667().getLeastSignificantBits() % 1200L;
        if (((long)maid.field_6012 + offset) % 1200L != 0L) {
            return;
        }
        ChatBubbleManager bubbleManager = maid.getChatBubbleManager();
        boolean empty = bubbleManager.getChatBubbleDataCollection().isEmpty();
        if (!empty) {
            return;
        }
        class_4168 activity = maid.getScheduleDetail();
        if (activity == class_4168.field_18597) {
            String randomEmoji = RandomEmoji.getRandomEmoji(EMOJI_MAP.get(SLEEP));
            class_5250 literal = class_2561.method_43470((String)randomEmoji);
            bubbleManager.addChatBubble(TextChatBubbleData.type2((class_2561)literal));
            return;
        }
        if (activity == class_4168.field_18595 || maid.getTask() == TaskManager.getIdleTask()) {
            String randomEmoji = RandomEmoji.getRandomEmoji(EMOJI_MAP.get(IDLE));
            class_5250 literal = class_2561.method_43470((String)randomEmoji);
            bubbleManager.addChatBubble(TextChatBubbleData.type2((class_2561)literal));
            return;
        }
        if (activity == class_4168.field_18596) {
            String randomEmoji = RandomEmoji.getRandomEmoji(EMOJI_MAP.get(WORK));
            class_5250 literal = class_2561.method_43470((String)randomEmoji);
            bubbleManager.addChatBubble(TextChatBubbleData.type2((class_2561)literal));
        }
    }

    public static void addHurtChatText(MaidDamageEvent event) {
        EntityMaid maid = event.getMaid();
        ChatBubbleManager bubbleManager = maid.getChatBubbleManager();
        boolean empty = bubbleManager.getChatBubbleDataCollection().isEmpty();
        if (empty) {
            String randomEmoji = RandomEmoji.getRandomEmoji(EMOJI_MAP.get(HURT));
            class_5250 literal = class_2561.method_43470((String)randomEmoji);
            bubbleManager.addChatBubble(TextChatBubbleData.type2((class_2561)literal));
        }
    }

    private static String getRandomEmoji(String[] emojis) {
        if (emojis == null || emojis.length == 0) {
            return "";
        }
        int index = (int)(Math.random() * (double)emojis.length);
        return emojis[index];
    }
}

