/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import java.io.IOException;
import java.lang.reflect.Type;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;

@JsonAdapter(value=Serializer.class)
public enum FormatVersion {
    LEGACY("=1.10.0"),
    NEW(">=1.12.0");

    private final VersionPredicate versionRange;

    private FormatVersion(String version) {
        this.versionRange = FormatVersion.createFromVersionSpec(version);
    }

    public static FormatVersion forValue(String value) throws IOException, VersionParsingException {
        Version inputVersion = Version.parse((String)value);
        if (FormatVersion.NEW.versionRange.test((Object)inputVersion)) {
            return NEW;
        }
        return LEGACY;
    }

    public String toValue() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "1.10.0";
            case 1 -> "1.12.0";
        };
    }

    private static VersionPredicate createFromVersionSpec(String spec) {
        try {
            return VersionPredicate.parse((String)spec);
        }
        catch (VersionParsingException e) {
            TouhouLittleMaid.LOGGER.fatal("Failed to parse version spec {}", (Object)spec, (Object)e);
            throw new RuntimeException("Failed to parse spec", e);
        }
    }

    protected static class Serializer
    implements JsonSerializer<FormatVersion>,
    JsonDeserializer<FormatVersion> {
        protected Serializer() {
        }

        public FormatVersion deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                return FormatVersion.forValue(json.getAsString());
            }
            catch (IOException | VersionParsingException e) {
                throw new RuntimeException(e);
            }
        }

        public JsonElement serialize(FormatVersion src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toValue());
        }
    }
}

