package cn.sh1rocu.touhoulittlemaid.util.itemhandler;

import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import org.jetbrains.annotations.NotNull;

public class ItemStackHandler implements IItemHandler, IItemHandlerModifiable, INBTSerializable<class_2487> {
    @Override
    public void readFromNbt(class_2487 tag) {
        if (tag.method_10545(TAG_INVENTORY)) {
            this.deserializeNBT(tag.method_10562(TAG_INVENTORY));
        }
    }

    @Override
    public void writeToNbt(class_2487 tag) {
        tag.method_10566(TAG_INVENTORY, this.serializeNBT());
    }

    protected class_2371<class_1799> stacks;

    public ItemStackHandler() {
        this(1);
    }

    public ItemStackHandler(int size) {
        this.stacks = class_2371.method_10213(size, class_1799.field_8037);
    }

    public ItemStackHandler(class_2371<class_1799> stacks) {
        this.stacks = stacks;
    }

    public void setSize(int size) {
        this.stacks = class_2371.method_10213(size, class_1799.field_8037);
    }

    public void setStackInSlot(int slot, @NotNull class_1799 stack) {
        this.validateSlotIndex(slot);
        this.stacks.set(slot, stack);
        this.onContentsChanged(slot);
    }

    public int getSlots() {
        return this.stacks.size();
    }

    public @NotNull class_1799 getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.stacks.get(slot);
    }

    public @NotNull class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        } else if (!this.isItemValid(slot, stack)) {
            return stack;
        } else {
            this.validateSlotIndex(slot);
            class_1799 existing = this.stacks.get(slot);
            int limit = this.getStackLimit(slot, stack);
            if (!existing.method_7960()) {
                if (!ItemHandlerHelper.canItemStacksStack(stack, existing)) {
                    return stack;
                }

                limit -= existing.method_7947();
            }

            if (limit <= 0) {
                return stack;
            } else {
                boolean reachedLimit = stack.method_7947() > limit;
                if (!simulate) {
                    if (existing.method_7960()) {
                        this.stacks.set(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, limit) : stack);
                    } else {
                        existing.method_7933(reachedLimit ? limit : stack.method_7947());
                    }

                    this.onContentsChanged(slot);
                }

                return reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, stack.method_7947() - limit) : class_1799.field_8037;
            }
        }
    }

    public @NotNull class_1799 extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return class_1799.field_8037;
        } else {
            this.validateSlotIndex(slot);
            class_1799 existing = this.stacks.get(slot);
            if (existing.method_7960()) {
                return class_1799.field_8037;
            } else {
                int toExtract = Math.min(amount, existing.method_7914());
                if (existing.method_7947() <= toExtract) {
                    if (!simulate) {
                        this.stacks.set(slot, class_1799.field_8037);
                        this.onContentsChanged(slot);
                        return existing;
                    } else {
                        return existing.method_7972();
                    }
                } else {
                    if (!simulate) {
                        this.stacks.set(slot, ItemHandlerHelper.copyStackWithSize(existing, existing.method_7947() - toExtract));
                        this.onContentsChanged(slot);
                    }

                    return ItemHandlerHelper.copyStackWithSize(existing, toExtract);
                }
            }
        }
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, @NotNull class_1799 stack) {
        return Math.min(this.getSlotLimit(slot), stack.method_7914());
    }

    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        return true;
    }

    public class_2487 serializeNBT() {
        class_2499 nbtTagList = new class_2499();

        for (int i = 0; i < this.stacks.size(); ++i) {
            if (!this.stacks.get(i).method_7960()) {
                class_2487 itemTag = new class_2487();
                itemTag.method_10569("Slot", i);
                this.stacks.get(i).method_7953(itemTag);
                nbtTagList.add(itemTag);
            }
        }

        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", nbtTagList);
        nbt.method_10569("Size", this.stacks.size());
        return nbt;
    }

    public void deserializeNBT(class_2487 nbt) {
        this.setSize(nbt.method_10573("Size", 3) ? nbt.method_10550("Size") : this.stacks.size());
        class_2499 tagList = nbt.method_10554("Items", 10);

        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 itemTags = tagList.method_10602(i);
            int slot = itemTags.method_10550("Slot");
            if (slot >= 0 && slot < this.stacks.size()) {
                this.stacks.set(slot, class_1799.method_7915(itemTags));
            }
        }

        this.onLoad();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    protected void onLoad() {
    }

    protected void onContentsChanged(int slot) {
    }
}
