package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ErrorCode;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ResponseCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ServiceType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendUserChatMessage;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.apache.commons.lang3.StringUtils;

import java.net.http.HttpRequest;

@Environment(EnvType.CLIENT)
public class STTCallback implements ResponseCallback<String> {
    private final class_1657 player;
    private final EntityMaid maid;

    public STTCallback(class_1657 player, EntityMaid maid) {
        this.player = player;
        this.maid = maid;
    }

    @Override
    public void onFailure(HttpRequest request, Throwable throwable, int errorCode) {
        String cause = throwable.getLocalizedMessage();
        class_5250 errorMessage = ErrorCode.getErrorMessage(ServiceType.STT, errorCode, cause);
        player.method_43496(errorMessage.method_27692(class_124.field_1061));
        TouhouLittleMaid.LOGGER.error("STT request failed: {}, error is {}", request, throwable.getMessage());
    }

    @Override
    public void onSuccess(String chatText) {
        if (StringUtils.isNotBlank(chatText)) {
            ChatClientInfo clientInfo = ChatClientInfo.fromMaid(this.maid);
            ClientPlayNetworking.send(SendUserChatMessage.ID, SendUserChatMessage.encode(maid.method_5628(), chatText, clientInfo));
            String name = player.method_5820();
            String format = String.format("<%s> %s", name, chatText);
            player.method_43496(class_2561.method_43470(format).method_27692(class_124.field_1080));
        } else {
            class_5250 component = class_2561.method_43471("ai.touhou_little_maid.chat.stt.content_is_empty");
            player.method_43496(component.method_27692(class_124.field_1080));
        }
    }
}