package com.github.tartaricacid.touhoulittlemaid.api.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.mixin.accessor.CropBlockAccessor;
import io.github.fabricators_of_create.porting_lib.common.util.IPlantable;
import net.minecraft.class_1798;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5712;
import net.minecraft.class_6088;

public interface ISpecialCropHandler {
    /**
     * 判断是否是种子，在前面 Item 基础上增加额外判断
     */
    default boolean isSeed(class_1799 stack) {
        return true;
    }

    /**
     * 判断是否可以收获
     */
    default boolean canHarvest(EntityMaid maid, class_2338 cropPos, class_2680 cropState) {
        return false;
    }

    /**
     * 执行收获逻辑
     *
     * @param isDestroyMode 当女仆持有锄头时，此值为 true，表示直接破坏
     *                      否则是类似于右键收获
     */
    default void harvest(EntityMaid maid, class_2338 cropPos, class_2680 cropState, boolean isDestroyMode) {
        if (isDestroyMode) {
            maid.destroyBlock(cropPos);
        } else if (cropState.method_26204() instanceof CropBlockAccessor crop) {
            class_2586 blockEntity = cropState.method_31709() ? maid.field_6002.method_8321(cropPos) : null;
            maid.dropResourcesToMaidInv(cropState, maid.field_6002, cropPos, blockEntity, maid, maid.method_6047());
            maid.field_6002.method_20290(class_6088.field_31144, cropPos, class_2248.method_9507(cropState));
            // 直接设置 Age 为 0
            if (cropState.method_28498(crop.tlmAgeProperty())) {
                try {
                    cropState = cropState.method_47968(crop.tlmAgeProperty(), 0);
                } catch (IllegalArgumentException ignore) {
                }
            }
            maid.field_6002.method_8652(cropPos, cropState, class_2248.field_31036);
            maid.field_6002.method_33596(maid, class_5712.field_28733, cropPos);
        }
    }

    /**
     * 判断是否可以种植
     */
    default boolean canPlant(EntityMaid maid, class_2338 basePos, class_2680 baseState, class_1799 seed) {
        class_2680 aboveState = maid.field_6002.method_8320(basePos.method_10084());
        if (!aboveState.method_45474() || aboveState.method_51176()) {
            return false;
        }
        if (seed.method_7909() instanceof class_1798 blockNamedItem) {
            class_2248 block = blockNamedItem.method_7711();
            if (block instanceof IPlantable plant) {
                return baseState.canSustainPlant(maid.field_6002, basePos, class_2350.field_11036, plant);
            }
        }
        return false;
    }

    /**
     * 执行种植逻辑
     */
    default class_1799 plant(EntityMaid maid, class_2338 basePos, class_2680 baseState, class_1799 seed) {
        if (seed.method_7909() instanceof class_1798 blockNamedItem) {
            class_2248 block = blockNamedItem.method_7711();
            if (block instanceof IPlantable) {
                maid.placeItemBlock(basePos.method_10084(), seed);
            }
        }
        return seed;
    }
}