package com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ConditionalHold {
    private static final String EMPTY_MAINHAND = "hold_mainhand:empty";
    private static final String EMPTY_OFFHAND = "hold_offhand:empty";
    private static final String EMPTY = "";
    private final int preSize;
    private final String idPre;
    private final String tagPre;
    private final String extraPre;
    private final List<class_2960> idTest = Lists.newArrayList();
    private final List<class_6862<class_1792>> tagTest = Lists.newArrayList();
    private final List<class_1839> extraTest = Lists.newArrayList();
    private final List<String> innerTest = Lists.newArrayList();

    public ConditionalHold(class_1268 hand) {
        if (hand == class_1268.field_5808) {
            idPre = "hold_mainhand$";
            tagPre = "hold_mainhand#";
            extraPre = "hold_mainhand:";
            preSize = 14;
        } else {
            idPre = "hold_offhand$";
            tagPre = "hold_offhand#";
            extraPre = "hold_offhand:";
            preSize = 13;
        }
    }

    public void addTest(String name) {
        if (name.length() <= preSize) {
            return;
        }
        String substring = name.substring(preSize);
        if (name.startsWith(idPre) && class_2960.method_20207(substring)) {
            idTest.add(new class_2960(substring));
        }
        if (name.startsWith(tagPre) && class_2960.method_20207(substring)) {
            tagTest.add(class_6862.method_40092(
                    class_7924.field_41197,
                    new class_2960(substring)
            ));
        }
        if (name.startsWith(extraPre)) {
            if (substring.equals(class_1839.field_8952.name().toLowerCase(Locale.US))) {
                return;
            }
            Arrays.stream(class_1839.values()).filter(a -> a.name().toLowerCase(Locale.US).equals(substring)).findFirst().ifPresent(extraTest::add);
            innerTest.add(name);
        }
    }

    public String doTest(IMaid maid, class_1268 hand) {
        if (maid.asEntity().method_5998(hand).method_7960()) {
            return hand == class_1268.field_5808 ? EMPTY_MAINHAND : EMPTY_OFFHAND;
        }
        String result = doIdTest(maid, hand);
        if (result.isEmpty()) {
            result = doTagTest(maid, hand);
            if (result.isEmpty()) {
                return doExtraTest(maid, hand);
            }
            return result;
        }
        return result;
    }

    private String doIdTest(IMaid maid, class_1268 hand) {
        if (idTest.isEmpty()) {
            return EMPTY;
        }
        class_1799 itemInHand = maid.asEntity().method_5998(hand);
        class_2960 registryName = class_7923.field_41178.method_10221(itemInHand.method_7909());
        if (registryName == null) {
            return EMPTY;
        }
        if (idTest.contains(registryName)) {
            return idPre + registryName;
        }
        return EMPTY;
    }

    private String doTagTest(IMaid maid, class_1268 hand) {
        if (tagTest.isEmpty()) {
            return EMPTY;
        }
        class_1799 itemInHand = maid.asEntity().method_5998(hand);
        return tagTest.stream().filter(itemInHand::method_31573).findFirst().map(itemTagKey -> tagPre + itemTagKey.comp_327()).orElse(EMPTY);
    }

    private String doExtraTest(IMaid maid, class_1268 hand) {
        if (extraTest.isEmpty() && innerTest.isEmpty()) {
            return EMPTY;
        }
        String innerName = InnerClassify.doClassifyTest(extraPre, maid, hand);
        if (StringUtils.isNotBlank(innerName) && this.innerTest.contains(innerName)) {
            return innerName;
        }
        class_1839 anim = maid.asEntity().method_5998(hand).method_7976();
        if (this.extraTest.contains(anim)) {
            return extraPre + anim.name().toLowerCase(Locale.US);
        }
        return EMPTY;
    }
}