package com.github.tartaricacid.touhoulittlemaid.client.overlay;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBroom;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_5481;

public class BroomTipsOverlay {
    private static final class_2960 BG = new class_2960(TouhouLittleMaid.MOD_ID, "textures/gui/download_background.png");

    public static final BroomTipsOverlay INSTANCE = new BroomTipsOverlay();

    public void render(@NotNull class_332 guiGraphics, float tickDelta) {
        class_310 minecraft = class_310.method_1551();
        class_315 options = minecraft.field_1690;
        class_1657 player = minecraft.field_1724;
        if (options.field_1842) {
            return;
        }
        if (player == null) {
            return;
        }
        class_1297 vehicle = player.method_5854();
        if (vehicle instanceof EntityBroom broom && !broom.method_5703(e -> e instanceof EntityMaid)) {
            int screenHeight = guiGraphics.method_51443();
            int screenWidth = guiGraphics.method_51421();
            class_2561 tip = class_2561.method_43471("message.touhou_little_maid.broom.unable_fly");
            List<class_5481> split = minecraft.field_1772.method_1728(tip, 150);
            int offset = (screenHeight / 2 - 5) - split.size() * 10;
            guiGraphics.method_25302(BG, screenWidth / 2 - 8, offset - 2, 48, 16, 16, 16);
            offset += 18;
            for (class_5481 sequence : split) {
                int width = minecraft.field_1772.method_30880(sequence);
                guiGraphics.method_35720(minecraft.field_1772, sequence, (screenWidth - width) / 2, offset, 0xFFFFFF);
                offset += 10;
            }
        }
    }
}
