package com.github.tartaricacid.touhoulittlemaid.datagen.advancement;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.advancements.altar.AltarCraftTrigger;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.datagen.LootTableGenerator;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemEntityPlaceholder;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_189;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2048;
import net.minecraft.class_2080;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_8508;


public class BaseAdvancement {
    public static void generate(Consumer<class_161> saver) {
        class_161 root = make(InitItems.HAKUREI_GOHEI, "craft_gohei")
                .method_704(class_193.field_1257)
                .method_709("craft_hakurei_gohei", class_8508.class_8509.method_51352(id("hakurei_gohei")))
                .method_709("craft_sanae_gohei", class_8508.class_8509.method_51352(id("sanae_gohei")))
                .method_703(class_170.class_171.method_750(50))
                .method_694(saver, id("base/craft_gohei").toString());

        generateAltar(saver, root);

        generateMaid(saver, root);

        generateChair(saver, root);
    }

    private static void generateChair(Consumer<class_161> saver, class_161 root) {
        class_161 chair = make(InitItems.CHAIR, "craft_chair").method_701(root)
                .method_709("craft_chair", class_8508.class_8509.method_51352(id("chair")))
                .method_694(saver, id("base/craft_chair").toString());

        make(InitItems.CHANGE_CHAIR_MODEL, "change_chair_model").method_701(chair)
                .method_709("maid_event", MaidEventTrigger.create(TriggerType.CHANGE_CHAIR_MODEL))
                .method_694(saver, id("base/change_chair_model").toString());
    }

    private static void generateMaid(Consumer<class_161> saver, class_161 root) {
        class_1799 stack = ItemEntityPlaceholder.setRecipeId(new class_1799(InitItems.ENTITY_PLACEHOLDER), id("spawn_box"));
        class_161 spawnMaid = make(stack, "spawn_maid").method_701(root)
                .method_709("altar_craft", AltarCraftTrigger.Instance.recipe(id("altar_recipe/spawn_box")))
                .method_703(class_170.class_171.method_34899(LootTableGenerator.CAKE))
                .method_694(saver, id("base/spawn_maid").toString());

        makeGoal(class_1802.field_17534, "tamed_maid").method_701(spawnMaid)
                .method_709("maid_event", MaidEventTrigger.create(TriggerType.TAMED_MAID))
                .method_694(saver, id("base/tamed_maid").toString());

        make(InitItems.CHANGE_MAID_MODEL, "change_maid_model").method_701(spawnMaid)
                .method_709("maid_event", MaidEventTrigger.create(TriggerType.CHANGE_MAID_MODEL))
                .method_694(saver, id("base/change_maid_model").toString());

        make(class_1802.field_8565, "change_maid_sound").method_701(spawnMaid)
                .method_709("maid_event", MaidEventTrigger.create(TriggerType.CHANGE_MAID_SOUND))
                .method_694(saver, id("base/change_maid_sound").toString());
    }

    private static void generateAltar(Consumer<class_161> saver, class_161 root) {
        class_161 altar = make(class_1802.field_19058, "build_altar").method_701(root)
                .method_709("maid_event", MaidEventTrigger.create(TriggerType.BUILD_ALTAR))
                .method_703(class_170.class_171.method_34899(LootTableGenerator.ADVANCEMENT_POWER_POINT))
                .method_694(saver, id("base/build_altar").toString());

        class_2048.class_2049 predicate = class_2048.class_2049.method_8916().method_8921(InitEntities.FAIRY);
        make(InitItems.FAIRY_SPAWN_EGG, "kill_maid_fairy").method_701(altar)
                .method_709("killed_entity", class_2080.class_2083.method_8997(predicate))
                .method_694(saver, id("base/kill_maid_fairy").toString());

        make(InitItems.POWER_POINT, "pickup_power_point").method_701(altar)
                .method_709("maid_event", MaidEventTrigger.create(TriggerType.PICKUP_POWER_POINT))
                .method_694(saver, id("base/pickup_power_point").toString());
    }

    private static class_161.class_162 make(class_1935 item, String key) {
        class_5250 title = class_2561.method_43471(String.format("advancements.touhou_little_maid.base.%s.title", key));
        class_5250 desc = class_2561.method_43471(String.format("advancements.touhou_little_maid.base.%s.description", key));

        return class_161.class_162.method_707().method_697(item, title, desc,
                new class_2960(TouhouLittleMaid.MOD_ID, "textures/advancements/backgrounds/stone.png"),
                class_189.field_1254, true, true, false);
    }

    private static class_161.class_162 make(class_1799 item, String key) {
        class_5250 title = class_2561.method_43471(String.format("advancements.touhou_little_maid.base.%s.title", key));
        class_5250 desc = class_2561.method_43471(String.format("advancements.touhou_little_maid.base.%s.description", key));

        return class_161.class_162.method_707().method_20416(item, title, desc,
                new class_2960(TouhouLittleMaid.MOD_ID, "textures/advancements/backgrounds/stone.png"),
                class_189.field_1254, true, true, false);
    }

    private static class_161.class_162 makeGoal(class_1935 item, String key) {
        class_5250 title = class_2561.method_43471(String.format("advancements.touhou_little_maid.base.%s.title", key));
        class_5250 desc = class_2561.method_43471(String.format("advancements.touhou_little_maid.base.%s.description", key));

        return class_161.class_162.method_707().method_697(item, title, desc,
                new class_2960(TouhouLittleMaid.MOD_ID, "textures/advancements/backgrounds/stone.png"),
                class_189.field_1249, true, true, false);
    }

    private static class_2960 id(String id) {
        return new class_2960(TouhouLittleMaid.MOD_ID, id);
    }
}
