package com.github.tartaricacid.touhoulittlemaid.entity.projectile;

import com.google.common.base.Preconditions;
import java.util.Random;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3417;

public final class DanmakuShoot {
    private static final Random RANDOM = new Random();
    private static final double MAX_YAW = 2 * Math.PI;
    private static final int MIN_FAN_NUM = 2;

    private class_1937 world = null;
    private class_1309 thrower = null;
    private class_1309 target = null;
    private DanmakuColor color = DanmakuColor.RED;
    private DanmakuType type = DanmakuType.PELLET;
    private int impedingLevel = 0;
    private float gravity = 0.01f;
    private float damage = 1.0f;
    private float velocity = 0.2f;
    private float inaccuracy = 0.2f;
    private double yawTotal = 0;
    private int fanNum = 0;
    private boolean hurtEnderman = false;

    public static DanmakuShoot create() {
        return new DanmakuShoot();
    }

    public void aimedShot() {
        Preconditions.checkNotNull(world);
        Preconditions.checkNotNull(thrower);
        Preconditions.checkNotNull(target);
        if (!world.field_9236) {
            EntityDanmaku danmaku = new EntityDanmaku(world, thrower)
                    .setDamage(damage).setGravityVelocity(gravity)
                    .setDanmakuType(type).setColor(color)
                    .setImpedingLevel(impedingLevel).setHurtEnderman(hurtEnderman);
            float offset = 0.3f / target.method_17682();
            danmaku.method_7485(target.method_23317() - thrower.method_23317(), target.method_23318() - thrower.method_23318() - offset, target.method_23321() - thrower.method_23321(), velocity, inaccuracy);
            world.method_8649(danmaku);
        }
        world.method_43128(null, thrower.method_23317(), thrower.method_23318(), thrower.method_23321(), class_3417.field_14873, thrower.method_5634(), 1.0f, 0.8f);
    }

    public void fanShapedShot() {
        Preconditions.checkNotNull(world);
        Preconditions.checkNotNull(thrower);
        Preconditions.checkNotNull(target);
        Preconditions.checkArgument(yawTotal >= 0 && yawTotal <= MAX_YAW, "yaw should >=0 and <= 2π");
        Preconditions.checkArgument(fanNum >= MIN_FAN_NUM, "fan number should >=2");
        if (!world.field_9236) {
            float offset = 0.3f / target.method_17682();
            class_243 v = new class_243(target.method_23317() - thrower.method_23317(), target.method_23318() - thrower.method_23318() - offset, target.method_23321() - thrower.method_23321());
            double yaw = -(yawTotal / 2);
            double addYaw = yawTotal / (fanNum - 1);
            for (int i = 1; i <= fanNum; i++) {
                class_243 v1 = v.method_1024((float) yaw);
                yaw = yaw + addYaw;

                EntityDanmaku danmaku = new EntityDanmaku(world, thrower)
                        .setDamage(damage).setGravityVelocity(gravity)
                        .setDanmakuType(type).setColor(color)
                        .setImpedingLevel(impedingLevel).setHurtEnderman(hurtEnderman);
                danmaku.method_7485(v1.field_1352, v1.field_1351, v1.field_1350, velocity, inaccuracy);
                world.method_8649(danmaku);
            }
        }
        world.method_43128(null, thrower.method_23317(), thrower.method_23318(), thrower.method_23321(), class_3417.field_14873, thrower.method_5634(), 1.0f, 0.8f);
    }

    public DanmakuShoot setWorld(class_1937 world) {
        this.world = world;
        return this;
    }

    public DanmakuShoot setThrower(class_1309 thrower) {
        this.thrower = thrower;
        return this;
    }

    public DanmakuShoot setColor(DanmakuColor color) {
        this.color = color;
        return this;
    }

    public DanmakuShoot setRandomColor() {
        this.color = DanmakuColor.random(RANDOM);
        return this;
    }

    public DanmakuShoot setType(DanmakuType type) {
        this.type = type;
        return this;
    }

    public DanmakuShoot setRandomType() {
        this.type = DanmakuType.random(RANDOM);
        return this;
    }

    public DanmakuShoot setGravity(float gravity) {
        this.gravity = gravity;
        return this;
    }

    public DanmakuShoot setDamage(float damage) {
        this.damage = damage;
        return this;
    }

    public DanmakuShoot setTarget(class_1309 target) {
        this.target = target;
        return this;
    }

    public DanmakuShoot setVelocity(float velocity) {
        this.velocity = velocity;
        return this;
    }

    public DanmakuShoot setInaccuracy(float inaccuracy) {
        this.inaccuracy = inaccuracy;
        return this;
    }

    public DanmakuShoot setYawTotal(double yawTotal) {
        this.yawTotal = yawTotal;
        return this;
    }

    public DanmakuShoot setFanNum(int fanNum) {
        this.fanNum = fanNum;
        return this;
    }

    public DanmakuShoot setImpedingLevel(int level) {
        this.impedingLevel = level;
        return this;
    }

    public DanmakuShoot setHurtEnderman(boolean hurtEnderman) {
        this.hurtEnderman = hurtEnderman;
        return this;
    }
}
