package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFarmPlantTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFarmSurroundingMoveTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2282;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_7893;
import net.minecraft.world.level.block.*;
import java.util.List;

public class TaskCocoa implements IFarmTask {
    public static final class_2960 UID = new class_2960(TouhouLittleMaid.MOD_ID, "cocoa");

    @Override
    public class_2960 getUid() {
        return UID;
    }

    @Override
    public class_1799 getIcon() {
        return class_1802.field_8116.method_7854();
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        MaidFarmSurroundingMoveTask maidFarmSurroundingMoveTask = new MaidFarmSurroundingMoveTask(this, 0.6f);
        MaidFarmPlantTask maidFarmPlantTask = new MaidFarmPlantTask(this);
        return Lists.newArrayList(Pair.of(5, maidFarmSurroundingMoveTask), Pair.of(6, maidFarmPlantTask));
    }

    @Override
    public boolean isSeed(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8116;
    }

    @Override
    public boolean canHarvest(EntityMaid maid, class_2338 cropPos, class_2680 cropState) {
        return cropState.method_27852(class_2246.field_10302) && cropState.method_11654(class_2282.field_10779) >= 2;
    }

    @Override
    public void harvest(EntityMaid maid, class_2338 cropPos, class_2680 cropState) {
        maid.destroyBlock(cropPos);
    }

    @Override
    public boolean canPlant(EntityMaid maid, class_2338 basePos, class_2680 baseState, class_1799 seed) {
        basePos = basePos.method_10084();
        baseState = maid.field_6002.method_8320(basePos);
        if (baseState.method_26164(class_3481.field_15474) && seed.method_7909() == class_1802.field_8116) {
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2680 state = maid.field_6002.method_8320(basePos.method_10093(direction));
                if (state.method_45474()) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public class_1799 plant(EntityMaid maid, class_2338 basePos, class_2680 baseState, class_1799 seed) {
        if (seed.method_7909() == class_1802.field_8116) {
            basePos = basePos.method_10084();
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2338 directionPos = basePos.method_10093(direction);
                if (!seed.method_7960() && maid.canPlaceBlock(directionPos)) {
                    class_1937 world = maid.method_37908();
                    class_2680 cocoaState = class_2246.field_10302.method_9564().method_11657(class_2383.field_11177, direction.method_10153());
                    world.method_8652(directionPos, cocoaState, class_2248.field_31022);
                    //SoundType soundType = cocoaState.getSoundType(world, directionPos, maid);
                    class_2498 soundType = cocoaState.method_26231();
                    world.method_8396(null, directionPos, soundType.method_10598(), class_3419.field_15245,
                            (soundType.method_10597() + 1.0F) / 2.0F, soundType.method_10599() * 0.8F);
                    seed.method_7934(1);
                }
            }
        }
        return seed;
    }

    @Override
    public double getCloseEnoughDist() {
        return 2.5;
    }

    @Override
    public boolean checkCropPosAbove() {
        return false;
    }
}
