package com.github.tartaricacid.touhoulittlemaid.init;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidSchedule;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.sensor.MaidHostilesSensor;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.sensor.MaidNearestLivingEntitySensor;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.sensor.MaidPickupEntitiesSensor;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleRegister;
import com.github.tartaricacid.touhoulittlemaid.entity.item.*;
import com.github.tartaricacid.touhoulittlemaid.entity.monster.EntityFairy;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.EntityDanmaku;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.EntityThrowPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.MaidFishingHook;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1317;
import net.minecraft.class_2378;
import net.minecraft.class_2902;
import net.minecraft.class_2943;
import net.minecraft.class_2960;
import net.minecraft.class_4115;
import net.minecraft.class_4140;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4170;
import net.minecraft.class_4171;
import net.minecraft.class_5132;
import net.minecraft.class_7923;
import java.util.List;
import java.util.Optional;

public final class InitEntities {
    public static void init() {
        registerSerializer();
        addEntityAttributes();
        addEntitySpawnPlacements();
    }

    public static class_1299<EntityMaid> MAID = registerEntityType("maid", EntityMaid.TYPE);
    public static class_1299<EntityChair> CHAIR = registerEntityType("chair", EntityChair.TYPE);
    public static class_1299<EntityFairy> FAIRY = registerEntityType("fairy", EntityFairy.TYPE);
    public static class_1299<EntityDanmaku> DANMAKU = registerEntityType("danmaku", EntityDanmaku.TYPE);
    public static class_1299<EntityPowerPoint> POWER_POINT = registerEntityType("power_point", EntityPowerPoint.TYPE);
    public static class_1299<EntityExtinguishingAgent> EXTINGUISHING_AGENT = registerEntityType("extinguishing_agent", EntityExtinguishingAgent.TYPE);
    public static class_1299<EntityBox> BOX = registerEntityType("box", EntityBox.TYPE);
    public static class_1299<EntityThrowPowerPoint> THROW_POWER_POINT = registerEntityType("throw_power_point", EntityThrowPowerPoint.TYPE);
    public static class_1299<EntityTombstone> TOMBSTONE = registerEntityType("tombstone", EntityTombstone.TYPE);
    public static class_1299<EntitySit> SIT = registerEntityType("sit", EntitySit.TYPE);
    public static class_1299<EntityBroom> BROOM = registerEntityType("broom", EntityBroom.TYPE);
    public static class_1299<MaidFishingHook> FISHING_HOOK = registerEntityType("fishing_hook", MaidFishingHook.TYPE);

    public static class_4168 RIDE_IDLE = registerActivity("ride_idle", new class_4168("tlm_ride_idle"));
    public static class_4168 RIDE_WORK = registerActivity("ride_work", new class_4168("tlm_ride_work"));
    public static class_4168 RIDE_REST = registerActivity("ride_rest", new class_4168("tlm_ride_rest"));

    public static class_4140<List<class_1297>> VISIBLE_PICKUP_ENTITIES = registerMemoryModuleType("visible_pickup_entities", new class_4140<>(Optional.empty()));
    public static class_4140<class_4115> TARGET_POS = registerMemoryModuleType("target_pos", new class_4140<>(Optional.empty()));
    public static class_4149<MaidNearestLivingEntitySensor> MAID_NEAREST_LIVING_ENTITY_SENSOR = registerSensorType("maid_nearest_living_entity", new class_4149<>(MaidNearestLivingEntitySensor::new));
    public static class_4149<MaidHostilesSensor> MAID_HOSTILES_SENSOR = registerSensorType("maid_hostiles", new class_4149<>(MaidHostilesSensor::new));
    public static class_4149<MaidPickupEntitiesSensor> MAID_PICKUP_ENTITIES_SENSOR = registerSensorType("maid_pickup_entities", new class_4149<>(MaidPickupEntitiesSensor::new));
    public static class_4170 MAID_DAY_SHIFT_SCHEDULES = registerSchedule("maid_day_shift_schedules",
            // 06:00 ~ 18:00 工作
            // 18:00 ~ 22:00 娱乐
            // 22:00 ~ 06:00 睡觉
            new class_4171(new class_4170())
                    .method_19221(0, class_4168.field_18596)
                    .method_19221(12000, class_4168.field_18595)
                    .method_19221(16000, class_4168.field_18597)
                    .method_19220()
    );
    public static class_4170 MAID_NIGHT_SHIFT_SCHEDULES = registerSchedule("maid_night_shift_schedules",
            // 18:00 ~ 06:00 工作
            // 06:00 ~ 14:00 睡觉
            // 14:00 ~ 18:00 娱乐
            new class_4171(new class_4170())
                    .method_19221(0, class_4168.field_18597)
                    .method_19221(8000, class_4168.field_18595)
                    .method_19221(12000, class_4168.field_18596)
                    .method_19220()
    );
    public static class_4170 MAID_ALL_DAY_SCHEDULES = registerSchedule("maid_all_day_schedules",
            new class_4171(new class_4170()).method_19221(0, class_4168.field_18596).method_19220());

    private static <T extends class_1299<?>> T registerEntityType(String id, T eType) {
        return class_2378.method_10230(class_7923.field_41177, new class_2960(TouhouLittleMaid.MOD_ID, id), eType);
    }

    private static <T extends class_4140<?>> T registerMemoryModuleType(String id, T mType) {
        return class_2378.method_10230(class_7923.field_41129, new class_2960(TouhouLittleMaid.MOD_ID, id), mType);
    }

    private static <T extends class_4149<?>> T registerSensorType(String id, T sType) {
        return class_2378.method_10230(class_7923.field_41130, new class_2960(TouhouLittleMaid.MOD_ID, id), sType);
    }

    private static class_4170 registerSchedule(String id, class_4170 schedule) {
        return class_2378.method_10230(class_7923.field_41131, new class_2960(TouhouLittleMaid.MOD_ID, id), schedule);
    }

    private static class_4168 registerActivity(String id, class_4168 activity) {
        return class_2378.method_10230(class_7923.field_41132, new class_2960(TouhouLittleMaid.MOD_ID, id), activity);
    }

    private static void registerSerializer() {
        class_2943.method_12720(MaidSchedule.DATA);
        class_2943.method_12720(ChatBubbleRegister.INSTANCE);
    }

    private static void addEntityAttribute(class_1299<? extends class_1309> type, class_5132.class_5133 builder) {
        FabricDefaultAttributeRegistry.register(type, builder);
    }

    private static void addEntityAttributes() {
        addEntityAttribute(EntityMaid.TYPE, EntityMaid.createAttributes());
        addEntityAttribute(EntityChair.TYPE, class_1309.method_26827());
        addEntityAttribute(EntityBroom.TYPE, class_1309.method_26827());
        addEntityAttribute(EntityFairy.TYPE, EntityFairy.createFairyAttributes());
    }

    private static void addEntitySpawnPlacements() {
        class_1317.method_20637(InitEntities.FAIRY, class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, EntityFairy::checkFairySpawnRules);
    }
}
