package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.getResourceLocation;

public class MaidModelMessage {
    public static final class_2960 ID = getResourceLocation("maid_model");

    public static class_2540 encode(int id, class_2960 modelId) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(id);
        buf.method_10812(modelId);
        return buf;
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        int id = buf.readInt();
        class_2960 modelId = buf.method_10810();
        server.execute(() -> {
            class_1297 entity = player.field_6002.method_8469(id);
            if (entity instanceof EntityMaid maid && maid.method_6171(player)) {
                if (player.method_7337() || MaidConfig.MAID_CHANGE_MODEL.get()) {
                    maid.setIsYsmModel(false);
                    maid.setModelId(modelId.toString());
                    InitTrigger.MAID_EVENT.trigger(player, TriggerType.CHANGE_MAID_MODEL);
                } else {
                    player.method_43496(class_2561.method_43471("message.touhou_little_maid.change_model.disabled"));
                }
            }
        });
    }
}
