package com.github.tartaricacid.touhoulittlemaid.util;

import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public final class RenderHelper {
    public static void renderFloatingText(class_4587 poseStack, String text, class_243 vec, int color, float scale, float yOffset) {
        renderFloatingText(poseStack, text, vec.field_1352 + 0.5, vec.field_1351 + 1.5, vec.field_1350 + 0.5, color, scale, true, yOffset, true);
    }

    public static void renderFloatingText(class_4587 poseStack, String text, double x, double y, double z, int color, float scale, boolean center, float yOffset, boolean seeThrough) {
        class_310 minecraft = class_310.method_1551();
        class_4597.class_4598 buffer = minecraft.method_22940().method_23000();
        class_4184 camera = minecraft.field_1773.method_19418();
        if (camera.method_19332()) {
            class_327 font = minecraft.field_1772;
            double viewX = camera.method_19326().field_1352;
            double viewY = camera.method_19326().field_1351;
            double viewZ = camera.method_19326().field_1350;
            poseStack.method_22903();
            poseStack.method_46416((float) (x - viewX), (float) (y - viewY) + 0.07F, (float) (z - viewZ));
            poseStack.method_34425((new Matrix4f()).rotation(camera.method_23767()));
            poseStack.method_22905(-scale, -scale, scale);
            float fontX = center ? (float) (-font.method_1727(text)) / 2.0F : 0.0F;
            font.method_27521(text, fontX, yOffset, color, false, poseStack.method_23760().method_23761(), buffer, seeThrough ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, 0, 0xf000f0);
            poseStack.method_22909();
            buffer.method_22993();
        }
    }

    public static void renderLine(class_4587 poseStack, class_4588 consumer, class_243 start, class_243 end, float red, float green, float blue) {
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        Matrix3f matrix3f = poseStack.method_23760().method_23762();
        consumer.method_22918(matrix4f, (float) start.field_1352, (float) start.field_1351, (float) start.field_1350).method_22915(red, green, blue, 1.0F).method_23763(matrix3f, 1.0F, 0.0F, 0.0F).method_1344();
        consumer.method_22918(matrix4f, (float) end.field_1352, (float) end.field_1351, (float) end.field_1350).method_22915(red, green, blue, 1.0F).method_23763(matrix3f, 1.0F, 0.0F, 0.0F).method_1344();

        consumer.method_22918(matrix4f, (float) start.field_1352, (float) start.field_1351, (float) start.field_1350).method_22915(red, green, blue, 1.0F).method_23763(matrix3f, 0.0F, 1.0F, 0.0F).method_1344();
        consumer.method_22918(matrix4f, (float) end.field_1352, (float) end.field_1351, (float) end.field_1350).method_22915(red, green, blue, 1.0F).method_23763(matrix3f, 0.0F, 1.0F, 0.0F).method_1344();

        consumer.method_22918(matrix4f, (float) start.field_1352, (float) start.field_1351, (float) start.field_1350).method_22915(red, green, blue, 1.0F).method_23763(matrix3f, 0.0F, 0.0F, 1.0F).method_1344();
        consumer.method_22918(matrix4f, (float) end.field_1352, (float) end.field_1351, (float) end.field_1350).method_22915(red, green, blue, 1.0F).method_23763(matrix3f, 0.0F, 0.0F, 1.0F).method_1344();
    }

    public static void renderCylinder(class_4587 poseStack, class_4588 consumer, class_243 centerPos, double radius, int precision, float red, float green, float blue) {
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        Matrix3f matrix3f = poseStack.method_23760().method_23762();
        double precisionAngle = 2 * Math.PI / precision;
        for (int i = precision; i >= 0; i--) {
            double x1 = centerPos.field_1352 + radius * Math.cos(i * precisionAngle);
            double x2 = centerPos.field_1352 + radius * Math.cos((i - 1) * precisionAngle);
            double y = centerPos.field_1351;
            double z1 = centerPos.field_1350 + radius * Math.sin(i * precisionAngle);
            double z2 = centerPos.field_1350 + radius * Math.sin((i - 1) * precisionAngle);
            consumer.method_22918(matrix4f, (float) x1, (float) y, (float) z1).method_22915(red, green, blue, 1.0F).method_23763(matrix3f, 1.0F, 0.0F, 0.0F).method_1344();
            consumer.method_22918(matrix4f, (float) x2, (float) y, (float) z2).method_22915(red, green, blue, 1.0F).method_23763(matrix3f, 1.0F, 0.0F, 0.0F).method_1344();

            consumer.method_22918(matrix4f, (float) x1, (float) y, (float) z1).method_22915(red, green, blue, 1.0F).method_23763(matrix3f, 0.0F, 1.0F, 0.0F).method_1344();
            consumer.method_22918(matrix4f, (float) x2, (float) y, (float) z2).method_22915(red, green, blue, 1.0F).method_23763(matrix3f, 0.0F, 1.0F, 0.0F).method_1344();

            consumer.method_22918(matrix4f, (float) x1, (float) y, (float) z1).method_22915(red, green, blue, 1.0F).method_23763(matrix3f, 0.0F, 0.0F, 1.0F).method_1344();
            consumer.method_22918(matrix4f, (float) x2, (float) y, (float) z2).method_22915(red, green, blue, 1.0F).method_23763(matrix3f, 0.0F, 0.0F, 1.0F).method_1344();
        }
    }
}
