/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.ChatClientInfo;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ErrorCode;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ResponseCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ServiceType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendUserChatMessage;
import java.net.http.HttpRequest;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.apache.commons.lang3.StringUtils;

@Environment(value=EnvType.CLIENT)
public class STTCallback
implements ResponseCallback<String> {
    private final class_1657 player;
    private final EntityMaid maid;

    public STTCallback(class_1657 player, EntityMaid maid) {
        this.player = player;
        this.maid = maid;
    }

    @Override
    public void onFailure(HttpRequest request, Throwable throwable, int errorCode) {
        String cause = throwable.getLocalizedMessage();
        class_5250 errorMessage = ErrorCode.getErrorMessage(ServiceType.STT, errorCode, cause);
        this.player.method_43496((class_2561)errorMessage.method_27692(class_124.field_1061));
        TouhouLittleMaid.LOGGER.error("STT request failed: {}, error is {}", (Object)request, (Object)throwable.getMessage());
    }

    @Override
    public void onSuccess(String chatText) {
        if (StringUtils.isNotBlank((CharSequence)chatText)) {
            ChatClientInfo clientInfo = ChatClientInfo.fromMaid(this.maid);
            ClientPlayNetworking.send((class_2960)SendUserChatMessage.ID, (class_2540)SendUserChatMessage.encode(this.maid.method_5628(), chatText, clientInfo));
            String name = this.player.method_5820();
            String format = String.format("<%s> %s", name, chatText);
            this.player.method_43496((class_2561)class_2561.method_43470((String)format).method_27692(class_124.field_1080));
        } else {
            class_5250 component = class_2561.method_43471((String)"ai.touhou_little_maid.chat.stt.content_is_empty");
            this.player.method_43496((class_2561)component.method_27692(class_124.field_1080));
        }
    }
}

