/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.game.gomoku;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.AIService;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Statue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ThreadLocalRandom;

public class ZhiZhangAIService
implements AIService {
    private static final ThreadLocalRandom RANDOM = ThreadLocalRandom.current();
    private final AIService.AIConfig aiConfig;
    private int[][] chessData;
    private int rows;
    private int cols;
    private int ai;
    private float attack;
    private Point bestPoint;
    private int rounds;
    private Statistics statistics;
    private Stack<Point> pathStack;
    private Stack<Point> bestPathStack;
    private long hashcode;
    private Map<Long, SituationCache> situationCacheMap;
    private static final int INFINITY = 999999999;
    private static final Map<String, Integer> SCORE = new LinkedHashMap<String, Integer>();
    private static final long[][] BLACK_ZOBRIST = new long[15][15];
    private static final long[][] WHITE_ZOBRIST = new long[15][15];

    public ZhiZhangAIService() {
        this(new AIService.AIConfig(6, 10, false, 0, 6));
    }

    public ZhiZhangAIService(AIService.AIConfig aiConfig) {
        this.aiConfig = aiConfig;
    }

    @Override
    public Point getPoint(int[][] chessData, Point point) {
        int vcx;
        this.initChessData(chessData);
        this.statistics = new Statistics();
        this.ai = 3 - point.type;
        this.bestPoint = null;
        this.attack = this.ai == 1 ? 1.8f : 0.5f;
        int depth = this.aiConfig.getDepth();
        if (this.rounds == 1 && this.ai == 1) {
            int centerX = this.cols / 2;
            int centerY = this.rows / 2;
            return new Point(centerX, centerY, this.ai);
        }
        if (this.aiConfig.getDepth() < 2) {
            return this.getBestPoint(point);
        }
        if (this.aiConfig.getDepth() > 4 && this.rounds < 4) {
            depth = 4;
        }
        if ((vcx = this.aiConfig.getVcx()) > 0) {
            int vcxDepth = this.aiConfig.getVcxDepth();
            long vcxStartTime = System.currentTimeMillis();
            this.bestPoint = this.deepeningVcx(true, vcxDepth, vcx == 2);
            long vcxEndTime = System.currentTimeMillis();
            this.statistics.setVcxTime((double)(vcxEndTime - vcxStartTime) / 1000.0);
        }
        if (this.bestPoint == null) {
            this.statistics.setNodes(0);
            this.statistics.setCacheHits(0);
            long minimaxStartTime = System.currentTimeMillis();
            this.bestPoint = this.deepeningMinimax(2, depth);
            long minimaxEndTime = System.currentTimeMillis();
            this.statistics.setMinimaxTime((double)(minimaxEndTime - minimaxStartTime) / 1000.0);
        }
        this.statistics.setPoint(this.bestPoint);
        this.statistics.setScore(this.bestPoint.score);
        this.statistics.setCaches(this.situationCacheMap.size());
        if (this.aiConfig.isDebug()) {
            TouhouLittleMaid.LOGGER.debug("============AI \u7edf\u8ba1[\u7b2c" + this.rounds + "\u56de\u5408]==========");
            TouhouLittleMaid.LOGGER.debug("\u641c\u7d22\u6df1\u5ea6\uff1a" + this.statistics.getDepth());
            TouhouLittleMaid.LOGGER.debug("\u641c\u7d22\u8282\u70b9\u6570\uff1a" + this.statistics.getNodes());
            TouhouLittleMaid.LOGGER.debug("\u53d1\u751f\u526a\u679d\u6570\uff1a" + this.statistics.getCuts());
            TouhouLittleMaid.LOGGER.debug("\u7f13\u5b58\u603b\u6570\uff1a" + this.statistics.getCaches());
            TouhouLittleMaid.LOGGER.debug("\u7f13\u5b58\u547d\u4e2d\u6570\uff1a" + this.statistics.getCacheHits());
            if (vcx > 0) {
                TouhouLittleMaid.LOGGER.debug("\u7b97\u6740\u6df1\u5ea6\uff1a" + this.statistics.getVcxDepth());
                TouhouLittleMaid.LOGGER.debug("\u7b97\u6740\u547d\u4e2d\uff1a" + (this.statistics.getVcx() == 1 ? "VCF" : (this.statistics.getVcx() == 2 ? "VCT" : "\u672a\u547d\u4e2d")));
            }
            TouhouLittleMaid.LOGGER.debug("\u6700\u4f73\u843d\u5b50\u70b9\uff1a" + String.valueOf(this.statistics.getPoint()));
            TouhouLittleMaid.LOGGER.debug("\u5f97\u5206\uff1a" + this.statistics.getScore());
            double time = this.statistics.getMinimaxTime() + this.statistics.getVcxTime();
            TouhouLittleMaid.LOGGER.debug("\u8017\u65f6\uff1a" + String.format("%.3f", time) + "s" + (String)(vcx > 0 ? ", VCX(" + this.statistics.getVcxTime() + "s)" : "") + ", MINIMAX(" + this.statistics.getMinimaxTime() + "s)");
            TouhouLittleMaid.LOGGER.debug("==================================");
        }
        this.situationCacheMap = null;
        return this.bestPoint;
    }

    @Override
    public Statue getStatue(int[][] chessData, Point point) {
        int nextY;
        int preY;
        int nextY2;
        int preY2;
        int nextX;
        int preX;
        int i;
        int rows = chessData[0].length;
        int cols = chessData.length;
        int x = point.x;
        int y = point.y;
        int type = point.type;
        int k = 1;
        for (i = 1; i < 5 && (preX = x - i) >= 0 && chessData[preX][y] == type; ++i) {
            if (++k != 5) continue;
            return Statue.WIN;
        }
        for (i = 1; i < 5 && (nextX = x + i) <= rows - 1 && chessData[nextX][y] == type; ++i) {
            if (++k != 5) continue;
            return Statue.WIN;
        }
        k = 1;
        for (i = 1; i < 5 && (preY2 = y - i) >= 0 && chessData[x][preY2] == type; ++i) {
            if (++k != 5) continue;
            return Statue.WIN;
        }
        for (i = 1; i < 5 && (nextY2 = y + i) <= cols - 1 && chessData[x][nextY2] == type; ++i) {
            if (++k != 5) continue;
            return Statue.WIN;
        }
        k = 1;
        for (i = 1; i < 5; ++i) {
            preX = x - i;
            preY = y - i;
            if (preX < 0 || preY < 0 || chessData[preX][preY] != type) break;
            if (++k != 5) continue;
            return Statue.WIN;
        }
        for (i = 1; i < 5; ++i) {
            nextX = x + i;
            nextY = y + i;
            if (nextX > rows - 1 || nextY > cols - 1 || chessData[nextX][nextY] != type) break;
            if (++k != 5) continue;
            return Statue.WIN;
        }
        k = 1;
        for (i = 1; i < 5; ++i) {
            nextX = x + i;
            preY = y - i;
            if (nextX > rows - 1 || preY < 0 || chessData[nextX][preY] != type) break;
            if (++k != 5) continue;
            return Statue.WIN;
        }
        for (i = 1; i < 5; ++i) {
            preX = x - i;
            nextY = y + i;
            if (preX < 0 || nextY > cols - 1 || chessData[preX][nextY] != type) break;
            if (++k != 5) continue;
            return Statue.WIN;
        }
        return Statue.IN_PROGRESS;
    }

    private void initChessData(int[][] chessData) {
        this.rows = chessData.length;
        this.cols = chessData[0].length;
        this.chessData = new int[this.cols][this.rows];
        int chessTotal = 0;
        for (int i = 0; i < this.cols; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int type = chessData[i][j];
                if (type == 0) continue;
                this.putChess(new Point(i, j, type));
                ++chessTotal;
            }
        }
        this.rounds = chessTotal / 2 + 1;
    }

    private Point deepeningVcx(boolean isAi, int maxDepth, boolean isVcf) {
        this.ai = isAi ? this.ai : 3 - this.ai;
        Point point = this.deepening(1, maxDepth, isVcf);
        if (!isAi) {
            this.ai = 3 - this.ai;
            if (point != null) {
                point.type = this.ai;
            }
        }
        return point;
    }

    private Point deepening(int depth, int maxDepth, boolean isVcf) {
        this.situationCacheMap = new HashMap<Long, SituationCache>(2048);
        Point point = null;
        while (depth <= maxDepth) {
            this.statistics.setVcxDepth(depth);
            if (this.aiConfig.isDebug()) {
                this.pathStack = new Stack();
            }
            if ((point = this.vcx(0, depth, isVcf)) != null) {
                if (this.aiConfig.isDebug()) {
                    StringBuilder pathOut = new StringBuilder();
                    pathOut.append(isVcf ? "VCF" : "VCT").append("\u8def\u5f84\uff1a");
                    this.bestPathStack.forEach(p -> pathOut.append(p).append(" "));
                }
                this.statistics.setVcx(isVcf ? 1 : 2);
                break;
            }
            depth += 2;
        }
        return point;
    }

    private Point vcx(int type, int depth, boolean isVcf) {
        boolean isRoot;
        SituationCache situationCache = this.situationCacheMap.get(this.hashcode);
        if (situationCache != null && situationCache.depth >= depth) {
            if (this.aiConfig.isDebug()) {
                this.statistics.incrCacheHits();
            }
            return situationCache.point;
        }
        if (depth == 0) {
            return null;
        }
        boolean bl = isRoot = type == 0;
        if (isRoot) {
            type = this.ai;
        }
        boolean isAI = type == this.ai;
        Point best = null;
        List<Point> pointList = this.getVcxPoints(type, isVcf);
        for (Point point : pointList) {
            if (this.aiConfig.isDebug()) {
                this.statistics.incrNodes();
                this.pathStack.push(point);
            }
            if (point.score >= RiskScore.HIGH_RISK.score) {
                if (this.aiConfig.isDebug()) {
                    if (isAI) {
                        this.bestPathStack = (Stack)this.pathStack.clone();
                    }
                    this.pathStack.pop();
                }
                return isAI ? point : null;
            }
            this.putChess(point);
            best = this.vcx(3 - type, depth - 1, isVcf);
            this.revokeChess(point);
            if (this.aiConfig.isDebug()) {
                this.pathStack.pop();
            }
            if (best == null) {
                if (isAI) continue;
                return null;
            }
            best = point;
            if (!isAI) continue;
            break;
        }
        this.situationCacheMap.put(this.hashcode, new SituationCache(best, depth));
        return best;
    }

    private List<Point> getVcxPoints(int type, boolean isVcf) {
        boolean isAI = type == this.ai;
        ArrayList<Point> attackPointList = new ArrayList<Point>();
        ArrayList<Point> defensePointList = new ArrayList<Point>();
        ArrayList<Point> vcxPointList = new ArrayList<Point>();
        boolean isDanger = false;
        for (int i = 0; i < this.cols; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                if (this.chessData[i][j] != 0) continue;
                Point point = new Point(i, j, type);
                int score = this.evaluate(point);
                if (score >= ChessModel.LIANWU.score) {
                    return Collections.singletonList(point);
                }
                if (isDanger) continue;
                Point foePoint = new Point(i, j, 3 - type);
                int foeScore = this.evaluate(foePoint);
                if (foeScore >= ChessModel.LIANWU.score) {
                    isDanger = true;
                    defensePointList.clear();
                    defensePointList.add(point);
                    continue;
                }
                if (score >= RiskScore.MEDIUM_RISK.score) {
                    attackPointList.add(point);
                    continue;
                }
                if (isAI) {
                    if (this.checkSituation(point, ChessModel.CHONGSI)) {
                        vcxPointList.add(point);
                        continue;
                    }
                    if (isVcf || !this.checkSituation(point, ChessModel.HUOSAN)) continue;
                    vcxPointList.add(point);
                    continue;
                }
                if (isVcf || !this.checkSituation(point, ChessModel.CHONGSI) && foeScore < ChessModel.HUOSI.score) continue;
                defensePointList.add(point);
            }
        }
        ArrayList<Point> pointList = new ArrayList<Point>();
        if (!isDanger) {
            if (!attackPointList.isEmpty()) {
                attackPointList.sort((p1, p2) -> {
                    if (p1.score == p2.score) {
                        return 0;
                    }
                    if (p1.score > p2.score) {
                        return -1;
                    }
                    return 1;
                });
                if (isAI) {
                    return attackPointList;
                }
                pointList.addAll(attackPointList);
            }
            if (!vcxPointList.isEmpty()) {
                pointList.addAll(vcxPointList);
            }
        }
        if (!defensePointList.isEmpty()) {
            if (isAI) {
                pointList.addAll(defensePointList);
            } else {
                pointList.addAll(0, defensePointList);
            }
        }
        return pointList;
    }

    private void putChess(Point point) {
        this.chessData[point.x][point.y] = point.type;
        this.calculateHashCode(point);
    }

    private void revokeChess(Point point) {
        this.chessData[point.x][point.y] = 0;
        this.calculateHashCode(point);
    }

    private long calculateHashCode(Point point) {
        int x = point.x;
        int y = point.y;
        this.hashcode ^= point.type == 1 ? BLACK_ZOBRIST[x][y] : WHITE_ZOBRIST[x][y];
        return this.hashcode;
    }

    private Point getBestPoint(Point point) {
        Point best = null;
        int score = -999999999;
        for (int i = 0; i < this.cols; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                Point p;
                int val;
                if (this.chessData[i][j] != 0 || (val = Math.round((float)this.evaluate(p = new Point(i, j, this.ai)) * this.attack) + this.evaluate(new Point(i, j, 3 - this.ai))) <= score) continue;
                score = val;
                best = p;
            }
        }
        return best;
    }

    private int minimax(int type, int depth) {
        boolean isRoot;
        boolean bl = isRoot = type == 0;
        if (isRoot) {
            type = this.ai;
        }
        boolean isAI = type == this.ai;
        int score = isAI ? -999999999 : 999999999;
        if (depth == 0) {
            return this.evaluateAll();
        }
        for (int i = 0; i < this.cols; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                if (this.chessData[i][j] != 0) continue;
                Point p = new Point(i, j, type);
                this.putChess(p);
                int curScore = this.minimax(3 - type, depth - 1);
                this.revokeChess(p);
                if (isAI) {
                    if (curScore <= score) continue;
                    score = curScore;
                    if (!isRoot) continue;
                    this.bestPoint = p;
                    continue;
                }
                if (curScore >= score) continue;
                score = curScore;
            }
        }
        return score;
    }

    private int minimax(int type, int depth, int alpha, int beta) {
        boolean isRoot;
        boolean bl = isRoot = type == 0;
        if (isRoot) {
            type = this.ai;
        }
        boolean isAI = type == this.ai;
        SituationCache situationCache = this.situationCacheMap.get(this.hashcode);
        if (situationCache != null && situationCache.depth >= depth) {
            if (this.aiConfig.isDebug()) {
                this.statistics.incrCacheHits();
            }
            return situationCache.score;
        }
        if (depth == 0) {
            return this.evaluateAll();
        }
        List<Point> pointList = this.getHeuristicPoints(type);
        if (isRoot && pointList.size() == 1) {
            if (this.aiConfig.isDebug()) {
                this.statistics.incrNodes();
            }
            this.bestPoint = pointList.get(0);
            return this.bestPoint.score;
        }
        ArrayList<Point> bestPointList = new ArrayList<Point>();
        for (Point point : pointList) {
            if (this.aiConfig.isDebug()) {
                this.statistics.incrNodes();
            }
            if (point.score >= ChessModel.LIANWU.score) {
                point.score = isAI ? 999999998 : -999999998;
            } else {
                this.putChess(point);
                point.score = this.minimax(3 - type, depth - 1, alpha, beta);
                this.revokeChess(point);
            }
            if (isAI) {
                if (point.score >= alpha) {
                    if (isRoot) {
                        if (point.score > alpha && this.rounds <= 1) {
                            bestPointList.clear();
                        }
                        bestPointList.add(point);
                    }
                    alpha = point.score;
                }
            } else if (point.score < beta) {
                beta = point.score;
            }
            if (alpha < beta) continue;
            if (!this.aiConfig.isDebug()) break;
            this.statistics.incrCuts();
            break;
        }
        if (isRoot) {
            int count = bestPointList.size();
            this.bestPoint = count == 1 ? (Point)bestPointList.get(0) : (this.rounds > 1 ? this.getRandomBestPoint(bestPointList) : this.getBestPoint(bestPointList));
        }
        int score = isAI ? alpha : beta;
        this.situationCacheMap.put(this.hashcode, new SituationCache(score, depth));
        return score;
    }

    private List<Point> getHeuristicPoints(int type) {
        ArrayList<Point> pointList;
        int max = this.aiConfig.getMaxNodes();
        ArrayList<Point> highPriorityPointList = new ArrayList<Point>();
        ArrayList<Point> lowPriorityPointList = new ArrayList<Point>();
        ArrayList<Point> alternatePointList = new ArrayList<Point>();
        ArrayList<Point> killPointList = new ArrayList<Point>();
        int dangerLevel = 0;
        for (int i = 0; i < this.cols; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                if (this.chessData[i][j] != 0) continue;
                Point point = new Point(i, j, type);
                int score = this.evaluate(point);
                if (score >= ChessModel.LIANWU.score) {
                    return Collections.singletonList(point);
                }
                if (dangerLevel == 2) continue;
                if (score >= RiskScore.MEDIUM_RISK.score) {
                    killPointList.add(point);
                }
                Point foePoint = new Point(i, j, 3 - type);
                int foeScore = this.evaluate(foePoint);
                int level = 0;
                if (foeScore >= ChessModel.LIANWU.score) {
                    level = 2;
                } else if (foeScore >= RiskScore.MEDIUM_RISK.score) {
                    level = 1;
                }
                if (level > 0) {
                    if (dangerLevel < level) {
                        dangerLevel = level;
                        highPriorityPointList.clear();
                    }
                    highPriorityPointList.add(point);
                }
                if (dangerLevel > 0) continue;
                if (RiskScore.between(score, RiskScore.LOW_RISK, RiskScore.MEDIUM_RISK) || RiskScore.between(foeScore, RiskScore.LOW_RISK, RiskScore.MEDIUM_RISK)) {
                    highPriorityPointList.add(point);
                    continue;
                }
                if (!highPriorityPointList.isEmpty()) continue;
                if (score >= ChessModel.CHONGSI.score || foeScore >= ChessModel.CHONGSI.score) {
                    lowPriorityPointList.add(point);
                    continue;
                }
                if (!lowPriorityPointList.isEmpty() || score < ChessModel.MIANYI.score) continue;
                alternatePointList.add(point);
            }
        }
        if (dangerLevel < 2 && !killPointList.isEmpty()) {
            return killPointList;
        }
        if (highPriorityPointList.isEmpty()) {
            if (lowPriorityPointList.isEmpty()) {
                if (alternatePointList.isEmpty()) {
                    return this.randomPoint(type, 1);
                }
                Collections.shuffle(alternatePointList);
                pointList = alternatePointList;
            } else {
                pointList = lowPriorityPointList;
            }
        } else {
            pointList = highPriorityPointList;
        }
        pointList.sort((p1, p2) -> {
            if (p1.score == p2.score) {
                return 0;
            }
            if (p1.score > p2.score) {
                return -1;
            }
            return 1;
        });
        return pointList.subList(0, Math.min(pointList.size(), max));
    }

    private Point deepeningMinimax(int depth, int maxDepth) {
        this.situationCacheMap = new HashMap<Long, SituationCache>(2048);
        Point best = null;
        while (depth <= maxDepth) {
            int score = this.minimax(0, depth, -999999999, 999999999);
            best = this.bestPoint;
            this.statistics.setPoint(best);
            this.statistics.setDepth(depth);
            this.statistics.setScore(score);
            if (Math.abs(score) >= 999999998) break;
            depth += 2;
        }
        return best;
    }

    private boolean checkHighPriorityPoint(Point point) {
        int huosanTotal = 0;
        int chongsiTotal = 0;
        int huoerTotal = 0;
        block6: for (int i = 1; i < 5; ++i) {
            String situation = this.getSituation(point, i);
            ChessModel chessModel = this.getChessModel(situation);
            if (chessModel == null) continue;
            switch (chessModel.ordinal()) {
                case 1: {
                    return true;
                }
                case 2: {
                    ++huosanTotal;
                    continue block6;
                }
                case 3: {
                    ++chongsiTotal;
                    continue block6;
                }
                case 4: {
                    ++huoerTotal;
                }
            }
        }
        if (chongsiTotal > 1 || chongsiTotal > 0 && huosanTotal > 0) {
            return true;
        }
        if (huosanTotal > 1) {
            return true;
        }
        if (huosanTotal <= 0 || huoerTotal > 0) {
            // empty if block
        }
        return false;
    }

    private Point getBestPoint(List<Point> pointList) {
        Point bestPoint = null;
        int bestScore = -999999999;
        for (Point point : pointList) {
            int score = Math.round((float)this.evaluate(point) * this.attack) + this.evaluate(new Point(point.x, point.y, 3 - point.type));
            if (score <= bestScore) continue;
            bestScore = score;
            bestPoint = point;
        }
        return bestPoint;
    }

    private Point getRandomBestPoint(List<Point> pointList) {
        Point bestPoint = null;
        Point secondPoint = null;
        int bestScore = -999999999;
        int secondScore = -999999999;
        for (Point point : pointList) {
            int score = Math.round((float)this.evaluate(point) * this.attack) + this.evaluate(new Point(point.x, point.y, 3 - point.type));
            if (score > bestScore) {
                bestScore = score;
                bestPoint = point;
            }
            if (score <= secondScore || score >= bestScore) continue;
            secondScore = score;
            secondPoint = point;
        }
        if (secondPoint == null) {
            return bestPoint;
        }
        return Math.random() < 0.5 ? bestPoint : secondPoint;
    }

    private List<Point> randomPoint(int type, int num) {
        ArrayList<Point> pointList = new ArrayList<Point>();
        for (int i = 0; i < this.cols; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                if (this.chessData[i][j] != 0) continue;
                pointList.add(new Point(i, j, type));
            }
        }
        Collections.shuffle(pointList);
        return pointList.subList(0, Math.min(num, pointList.size()));
    }

    private int evaluate(Point point) {
        int score = 0;
        int huosanTotal = 0;
        int chongsiTotal = 0;
        int tfTotal = 0;
        for (int i = 1; i < 5; ++i) {
            String situation = this.getSituation(point, i);
            ChessModel chessModel = this.getChessModel(situation);
            if (chessModel == null) continue;
            switch (chessModel.ordinal()) {
                case 2: {
                    ++huosanTotal;
                    if (!this.checkSituation(situation, ChessModel.CHONGSI)) break;
                    ++tfTotal;
                    break;
                }
                case 3: {
                    ++chongsiTotal;
                }
            }
            score += chessModel.score;
        }
        if (chongsiTotal > 1 || tfTotal > 1) {
            score += RiskScore.HIGH_RISK.score;
        } else if (chongsiTotal > 0 && huosanTotal > 0 || tfTotal > 0 && huosanTotal > 1) {
            score += RiskScore.MEDIUM_RISK.score;
        } else if (huosanTotal > 1) {
            score += RiskScore.LOW_RISK.score;
        }
        point.score = score;
        return score;
    }

    private int evaluateAll() {
        int aiScore = 0;
        int foeScore = 0;
        for (int i = 0; i < this.cols; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int type = this.chessData[i][j];
                if (type == 0) continue;
                int val = this.evaluate(new Point(i, j, type));
                if (type == this.ai) {
                    aiScore += val;
                    continue;
                }
                foeScore += val;
            }
        }
        return Math.round((float)aiScore * this.attack) - foeScore;
    }

    private boolean checkSituation(Point point, ChessModel ... chessModels) {
        for (int i = 1; i < 5; ++i) {
            String situation = this.getSituation(point, i);
            for (ChessModel chessModel : chessModels) {
                if (!this.checkSituation(situation, chessModel)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkSituation(String situation, ChessModel chessModel) {
        for (String value : chessModel.values) {
            if (!situation.contains(value)) continue;
            return true;
        }
        return false;
    }

    private ChessModel getChessModel(String situation) {
        for (ChessModel chessModel : ChessModel.values()) {
            for (String value : chessModel.values) {
                if (!situation.contains(value)) continue;
                return chessModel;
            }
        }
        return null;
    }

    private int getScore(String situation) {
        for (String key : SCORE.keySet()) {
            if (!situation.contains(key)) continue;
            return SCORE.get(key);
        }
        return 0;
    }

    private String getSituation(Point point, int direction) {
        direction = direction * 2 - 1;
        StringBuilder sb = new StringBuilder();
        this.appendChess(sb, point, direction, 4);
        this.appendChess(sb, point, direction, 3);
        this.appendChess(sb, point, direction, 2);
        this.appendChess(sb, point, direction, 1);
        sb.append(1);
        this.appendChess(sb, point, direction + 1, 1);
        this.appendChess(sb, point, direction + 1, 2);
        this.appendChess(sb, point, direction + 1, 3);
        this.appendChess(sb, point, direction + 1, 4);
        return sb.toString();
    }

    private void appendChess(StringBuilder sb, Point point, int direction, int offset) {
        int chess = this.relativePoint(point, direction, offset);
        if (chess > -1) {
            if (point.type == 2 && chess > 0) {
                chess = 3 - chess;
            }
            sb.append(chess);
        }
    }

    private int relativePoint(Point point, int direction, int offset) {
        int x = point.x;
        int y = point.y;
        switch (direction) {
            case 1: {
                x -= offset;
                break;
            }
            case 2: {
                x += offset;
                break;
            }
            case 3: {
                y -= offset;
                break;
            }
            case 4: {
                y += offset;
                break;
            }
            case 5: {
                x += offset;
                y -= offset;
                break;
            }
            case 6: {
                x -= offset;
                y += offset;
                break;
            }
            case 7: {
                x -= offset;
                y -= offset;
                break;
            }
            case 8: {
                x += offset;
                y += offset;
            }
        }
        if (x < 0 || y < 0 || x >= this.cols || y >= this.rows) {
            return -1;
        }
        return this.chessData[x][y];
    }

    static {
        for (ChessModel chessScore : ChessModel.values()) {
            for (String value : chessScore.values) {
                SCORE.put(value, chessScore.score);
            }
        }
        for (int i = 0; i < BLACK_ZOBRIST.length; ++i) {
            for (int j = 0; j < BLACK_ZOBRIST.length; ++j) {
                ZhiZhangAIService.BLACK_ZOBRIST[i][j] = RANDOM.nextLong();
                ZhiZhangAIService.WHITE_ZOBRIST[i][j] = RANDOM.nextLong();
            }
        }
    }

    private static class Statistics {
        private int depth;
        private Point point;
        private int score;
        private double minimaxTime;
        private int nodes;
        private int cuts;
        private int vcxDepth;
        private int vcx;
        private double vcxTime;
        private int caches;
        private int cacheHits;

        private Statistics() {
        }

        public void incrNodes() {
            ++this.nodes;
        }

        public void incrCuts() {
            ++this.cuts;
        }

        public void incrCacheHits() {
            ++this.cacheHits;
        }

        public int getDepth() {
            return this.depth;
        }

        public Point getPoint() {
            return this.point;
        }

        public int getScore() {
            return this.score;
        }

        public double getMinimaxTime() {
            return this.minimaxTime;
        }

        public int getNodes() {
            return this.nodes;
        }

        public int getCuts() {
            return this.cuts;
        }

        public int getVcxDepth() {
            return this.vcxDepth;
        }

        public int getVcx() {
            return this.vcx;
        }

        public double getVcxTime() {
            return this.vcxTime;
        }

        public int getCaches() {
            return this.caches;
        }

        public int getCacheHits() {
            return this.cacheHits;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public void setPoint(Point point) {
            this.point = point;
        }

        public void setScore(int score) {
            this.score = score;
        }

        public void setMinimaxTime(double minimaxTime) {
            this.minimaxTime = minimaxTime;
        }

        public void setNodes(int nodes) {
            this.nodes = nodes;
        }

        public void setCuts(int cuts) {
            this.cuts = cuts;
        }

        public void setVcxDepth(int vcxDepth) {
            this.vcxDepth = vcxDepth;
        }

        public void setVcx(int vcx) {
            this.vcx = vcx;
        }

        public void setVcxTime(double vcxTime) {
            this.vcxTime = vcxTime;
        }

        public void setCaches(int caches) {
            this.caches = caches;
        }

        public void setCacheHits(int cacheHits) {
            this.cacheHits = cacheHits;
        }
    }

    private static class SituationCache {
        private Point point;
        private int score;
        private final int depth;

        public SituationCache(int score, int depth) {
            this.score = score;
            this.depth = depth;
        }

        public SituationCache(Point point, int depth) {
            this.point = point;
            this.depth = depth;
        }
    }

    private static enum RiskScore {
        HIGH_RISK(800000),
        MEDIUM_RISK(500000),
        LOW_RISK(100000);

        final int score;

        private RiskScore(int score) {
            this.score = score;
        }

        public static boolean between(int score, RiskScore leftScore, RiskScore rightScore) {
            return score >= leftScore.score && score < rightScore.score;
        }
    }

    private static enum ChessModel {
        LIANWU(10000000, new String[]{"11111"}),
        HUOSI(1000000, new String[]{"011110"}),
        HUOSAN(10000, new String[]{"001110", "011100", "010110", "011010"}),
        CHONGSI(9000, new String[]{"11110", "01111", "10111", "11011", "11101"}),
        HUOER(100, new String[]{"001100", "011000", "000110", "001010", "010100"}),
        HUOYI(80, new String[]{"010200", "002010", "020100", "001020", "201000", "000102", "000201"}),
        MIANSAN(30, new String[]{"001112", "010112", "011012", "211100", "211010"}),
        MIANER(10, new String[]{"011200", "001120", "002110", "021100", "110000", "000011", "000112", "211000"}),
        MIANYI(1, new String[]{"001200", "002100", "000210", "000120", "210000", "000012"});

        final int score;
        final String[] values;

        private ChessModel(int score, String[] values) {
            this.score = score;
            this.values = values;
        }
    }
}

