/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.game.xqwlight;

import com.github.tartaricacid.touhoulittlemaid.api.game.xqwlight.Util;
import java.io.InputStream;
import java.util.Random;

public class Position {
    public static final int MATE_VALUE = 10000;
    public static final int BAN_VALUE = 9900;
    public static final int WIN_VALUE = 9800;
    public static final int NULL_SAFE_MARGIN = 400;
    public static final int NULL_OKAY_MARGIN = 200;
    public static final int DRAW_VALUE = 20;
    public static final int ADVANCED_VALUE = 3;
    public static final int MAX_MOVE_NUM = 256;
    public static final int MAX_GEN_MOVES = 128;
    public static final int MAX_BOOK_SIZE = 16384;
    public static final int PIECE_KING = 0;
    public static final int PIECE_ADVISOR = 1;
    public static final int PIECE_BISHOP = 2;
    public static final int PIECE_KNIGHT = 3;
    public static final int PIECE_ROOK = 4;
    public static final int PIECE_CANNON = 5;
    public static final int PIECE_PAWN = 6;
    public static final int RANK_TOP = 3;
    public static final int RANK_BOTTOM = 12;
    public static final int FILE_LEFT = 3;
    public static final int FILE_RIGHT = 11;
    public static final byte[] IN_BOARD = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] IN_FORT = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] LEGAL_SPAN = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final byte[] KNIGHT_PIN = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -16, 0, -16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int[] KING_DELTA = new int[]{-16, -1, 1, 16};
    public static final int[] ADVISOR_DELTA = new int[]{-17, -15, 15, 17};
    public static final int[][] KNIGHT_DELTA = new int[][]{{-33, -31}, {-18, 14}, {-14, 18}, {31, 33}};
    public static final int[][] KNIGHT_CHECK_DELTA = new int[][]{{-33, -18}, {-31, -14}, {14, 31}, {18, 33}};
    public static final int[] MVV_VALUE = new int[]{50, 10, 10, 30, 40, 30, 20, 0};
    public static final short[][] PIECE_VALUE = new short[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 9, 11, 13, 11, 9, 9, 9, 0, 0, 0, 0, 0, 0, 0, 19, 24, 34, 42, 44, 42, 34, 24, 19, 0, 0, 0, 0, 0, 0, 0, 19, 24, 32, 37, 37, 37, 32, 24, 19, 0, 0, 0, 0, 0, 0, 0, 19, 23, 27, 29, 30, 29, 27, 23, 19, 0, 0, 0, 0, 0, 0, 0, 14, 18, 20, 27, 29, 27, 20, 18, 14, 0, 0, 0, 0, 0, 0, 0, 7, 0, 13, 0, 16, 0, 13, 0, 7, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 0, 15, 0, 7, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 15, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 0, 0, 20, 23, 20, 0, 0, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 20, 0, 20, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 0, 0, 20, 23, 20, 0, 0, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 20, 0, 20, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90, 90, 90, 96, 90, 96, 90, 90, 90, 0, 0, 0, 0, 0, 0, 0, 90, 96, 103, 97, 94, 97, 103, 96, 90, 0, 0, 0, 0, 0, 0, 0, 92, 98, 99, 103, 99, 103, 99, 98, 92, 0, 0, 0, 0, 0, 0, 0, 93, 108, 100, 107, 100, 107, 100, 108, 93, 0, 0, 0, 0, 0, 0, 0, 90, 100, 99, 103, 104, 103, 99, 100, 90, 0, 0, 0, 0, 0, 0, 0, 90, 98, 101, 102, 103, 102, 101, 98, 90, 0, 0, 0, 0, 0, 0, 0, 92, 94, 98, 95, 98, 95, 98, 94, 92, 0, 0, 0, 0, 0, 0, 0, 93, 92, 94, 95, 92, 95, 94, 92, 93, 0, 0, 0, 0, 0, 0, 0, 85, 90, 92, 93, 78, 93, 92, 90, 85, 0, 0, 0, 0, 0, 0, 0, 88, 85, 90, 88, 90, 88, 90, 85, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206, 208, 207, 213, 214, 213, 207, 208, 206, 0, 0, 0, 0, 0, 0, 0, 206, 212, 209, 216, 233, 216, 209, 212, 206, 0, 0, 0, 0, 0, 0, 0, 206, 208, 207, 214, 216, 214, 207, 208, 206, 0, 0, 0, 0, 0, 0, 0, 206, 213, 213, 216, 216, 216, 213, 213, 206, 0, 0, 0, 0, 0, 0, 0, 208, 211, 211, 214, 215, 214, 211, 211, 208, 0, 0, 0, 0, 0, 0, 0, 208, 212, 212, 214, 215, 214, 212, 212, 208, 0, 0, 0, 0, 0, 0, 0, 204, 209, 204, 212, 214, 212, 204, 209, 204, 0, 0, 0, 0, 0, 0, 0, 198, 208, 204, 212, 212, 212, 204, 208, 198, 0, 0, 0, 0, 0, 0, 0, 200, 208, 206, 212, 200, 212, 206, 208, 200, 0, 0, 0, 0, 0, 0, 0, 194, 206, 204, 212, 200, 212, 204, 206, 194, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 100, 100, 96, 91, 90, 91, 96, 100, 100, 0, 0, 0, 0, 0, 0, 0, 98, 98, 96, 92, 89, 92, 96, 98, 98, 0, 0, 0, 0, 0, 0, 0, 97, 97, 96, 91, 92, 91, 96, 97, 97, 0, 0, 0, 0, 0, 0, 0, 96, 99, 99, 98, 100, 98, 99, 99, 96, 0, 0, 0, 0, 0, 0, 0, 96, 96, 96, 96, 100, 96, 96, 96, 96, 0, 0, 0, 0, 0, 0, 0, 95, 96, 99, 96, 100, 96, 99, 96, 95, 0, 0, 0, 0, 0, 0, 0, 96, 96, 96, 96, 96, 96, 96, 96, 96, 0, 0, 0, 0, 0, 0, 0, 97, 96, 100, 99, 101, 99, 100, 96, 97, 0, 0, 0, 0, 0, 0, 0, 96, 97, 98, 98, 98, 98, 98, 97, 96, 0, 0, 0, 0, 0, 0, 0, 96, 96, 97, 99, 99, 99, 97, 96, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 9, 11, 13, 11, 9, 9, 9, 0, 0, 0, 0, 0, 0, 0, 19, 24, 34, 42, 44, 42, 34, 24, 19, 0, 0, 0, 0, 0, 0, 0, 19, 24, 32, 37, 37, 37, 32, 24, 19, 0, 0, 0, 0, 0, 0, 0, 19, 23, 27, 29, 30, 29, 27, 23, 19, 0, 0, 0, 0, 0, 0, 0, 14, 18, 20, 27, 29, 27, 20, 18, 14, 0, 0, 0, 0, 0, 0, 0, 7, 0, 13, 0, 16, 0, 13, 0, 7, 0, 0, 0, 0, 0, 0, 0, 7, 0, 7, 0, 15, 0, 7, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 15, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
    public static final String[] STARTUP_FEN = new String[]{"rnbakabnr/9/1c5c1/p1p1p1p1p/9/9/P1P1P1P1P/1C5C1/9/RNBAKABNR w - - 0 1", "rnbakabnr/9/1c5c1/p1p1p1p1p/9/9/P1P1P1P1P/1C5C1/9/R1BAKABNR w - - 0 1", "rnbakabnr/9/1c5c1/p1p1p1p1p/9/9/P1P1P1P1P/1C5C1/9/R1BAKAB1R w - - 0 1", "rnbakabnr/9/1c5c1/p1p1p1p1p/9/9/9/1C5C1/9/RN2K2NR w - - 0 1"};
    public static final String FEN_PIECE = "        KABNRCP kabnrcp ";
    public static int PreGen_zobristKeyPlayer;
    public static int PreGen_zobristLockPlayer;
    public static int[][] PreGen_zobristKeyTable;
    public static int[][] PreGen_zobristLockTable;
    public static Random random;
    public static int bookSize;
    public static int[] bookLock;
    public static short[] bookMove;
    public static short[] bookValue;
    public int sdPlayer;
    public byte[] squares = new byte[256];
    public int zobristKey;
    public int zobristLock;
    public int vlWhite;
    public int vlBlack;
    public int moveNum;
    public int distance;
    public int[] mvList = new int[256];
    public int[] pcList = new int[256];
    public int[] keyList = new int[256];
    public boolean[] chkList = new boolean[256];

    public static boolean IN_BOARD(int sq) {
        return IN_BOARD[sq] != 0;
    }

    public static boolean IN_FORT(int sq) {
        return IN_FORT[sq] != 0;
    }

    public static int RANK_Y(int sq) {
        return sq >> 4;
    }

    public static int FILE_X(int sq) {
        return sq & 0xF;
    }

    public static int COORD_XY(int x, int y) {
        return x + (y << 4);
    }

    public static int SQUARE_FLIP(int sq) {
        return 254 - sq;
    }

    public static int FILE_FLIP(int x) {
        return 14 - x;
    }

    public static int RANK_FLIP(int y) {
        return 15 - y;
    }

    public static int MIRROR_SQUARE(int sq) {
        return Position.COORD_XY(Position.FILE_FLIP(Position.FILE_X(sq)), Position.RANK_Y(sq));
    }

    public static int SQUARE_FORWARD(int sq, int sd) {
        return sq - 16 + (sd << 5);
    }

    public static boolean KING_SPAN(int sqSrc, int sqDst) {
        return LEGAL_SPAN[sqDst - sqSrc + 256] == 1;
    }

    public static boolean ADVISOR_SPAN(int sqSrc, int sqDst) {
        return LEGAL_SPAN[sqDst - sqSrc + 256] == 2;
    }

    public static boolean BISHOP_SPAN(int sqSrc, int sqDst) {
        return LEGAL_SPAN[sqDst - sqSrc + 256] == 3;
    }

    public static int BISHOP_PIN(int sqSrc, int sqDst) {
        return sqSrc + sqDst >> 1;
    }

    public static int KNIGHT_PIN(int sqSrc, int sqDst) {
        return sqSrc + KNIGHT_PIN[sqDst - sqSrc + 256];
    }

    public static boolean HOME_HALF(int sq, int sd) {
        return (sq & 0x80) != sd << 7;
    }

    public static boolean AWAY_HALF(int sq, int sd) {
        return (sq & 0x80) == sd << 7;
    }

    public static boolean SAME_HALF(int sqSrc, int sqDst) {
        return ((sqSrc ^ sqDst) & 0x80) == 0;
    }

    public static boolean SAME_RANK(int sqSrc, int sqDst) {
        return ((sqSrc ^ sqDst) & 0xF0) == 0;
    }

    public static boolean SAME_FILE(int sqSrc, int sqDst) {
        return ((sqSrc ^ sqDst) & 0xF) == 0;
    }

    public static int SIDE_TAG(int sd) {
        return 8 + (sd << 3);
    }

    public static int OPP_SIDE_TAG(int sd) {
        return 16 - (sd << 3);
    }

    public static int SRC(int mv) {
        return mv & 0xFF;
    }

    public static int DST(int mv) {
        return mv >> 8;
    }

    public static int MOVE(int sqSrc, int sqDst) {
        return sqSrc + (sqDst << 8);
    }

    public static int MIRROR_MOVE(int mv) {
        return Position.MOVE(Position.MIRROR_SQUARE(Position.SRC(mv)), Position.MIRROR_SQUARE(Position.DST(mv)));
    }

    public static int MVV_LVA(int pc, int lva) {
        return MVV_VALUE[pc & 7] - lva;
    }

    public static int CHAR_TO_PIECE(char c) {
        return switch (c) {
            case 'K' -> 0;
            case 'A' -> 1;
            case 'B', 'E' -> 2;
            case 'H', 'N' -> 3;
            case 'R' -> 4;
            case 'C' -> 5;
            case 'P' -> 6;
            default -> -1;
        };
    }

    public void clearBoard() {
        this.sdPlayer = 0;
        for (int sq = 0; sq < 256; ++sq) {
            this.squares[sq] = 0;
        }
        this.zobristLock = 0;
        this.zobristKey = 0;
        this.vlBlack = 0;
        this.vlWhite = 0;
    }

    public void setIrrev() {
        this.pcList[0] = 0;
        this.mvList[0] = 0;
        this.chkList[0] = this.checked();
        this.moveNum = 1;
        this.distance = 0;
    }

    public void addPiece(int sq, int pc, boolean del) {
        int pcAdjust;
        this.squares[sq] = (byte)(del ? 0 : pc);
        if (pc < 16) {
            pcAdjust = pc - 8;
            this.vlWhite += del ? -PIECE_VALUE[pcAdjust][sq] : PIECE_VALUE[pcAdjust][sq];
        } else {
            pcAdjust = pc - 16;
            this.vlBlack += del ? -PIECE_VALUE[pcAdjust][Position.SQUARE_FLIP(sq)] : PIECE_VALUE[pcAdjust][Position.SQUARE_FLIP(sq)];
            pcAdjust += 7;
        }
        this.zobristKey ^= PreGen_zobristKeyTable[pcAdjust][sq];
        this.zobristLock ^= PreGen_zobristLockTable[pcAdjust][sq];
    }

    public void addPiece(int sq, int pc) {
        this.addPiece(sq, pc, false);
    }

    public void delPiece(int sq, int pc) {
        this.addPiece(sq, pc, true);
    }

    public void movePiece() {
        int sqSrc = Position.SRC(this.mvList[this.moveNum]);
        int sqDst = Position.DST(this.mvList[this.moveNum]);
        this.pcList[this.moveNum] = this.squares[sqDst];
        if (this.pcList[this.moveNum] > 0) {
            this.delPiece(sqDst, this.pcList[this.moveNum]);
        }
        byte pc = this.squares[sqSrc];
        this.delPiece(sqSrc, pc);
        this.addPiece(sqDst, pc);
    }

    public void undoMovePiece() {
        int sqSrc = Position.SRC(this.mvList[this.moveNum]);
        int sqDst = Position.DST(this.mvList[this.moveNum]);
        byte pc = this.squares[sqDst];
        this.delPiece(sqDst, pc);
        this.addPiece(sqSrc, pc);
        if (this.pcList[this.moveNum] > 0) {
            this.addPiece(sqDst, this.pcList[this.moveNum]);
        }
    }

    public void changeSide() {
        this.sdPlayer = 1 - this.sdPlayer;
        this.zobristKey ^= PreGen_zobristKeyPlayer;
        this.zobristLock ^= PreGen_zobristLockPlayer;
    }

    public boolean makeMove(int mv) {
        this.keyList[this.moveNum] = this.zobristKey;
        this.mvList[this.moveNum] = mv;
        this.movePiece();
        if (this.checked()) {
            this.undoMovePiece();
            return false;
        }
        this.changeSide();
        this.chkList[this.moveNum] = this.checked();
        ++this.moveNum;
        ++this.distance;
        return true;
    }

    public void undoMakeMove() {
        --this.moveNum;
        --this.distance;
        this.changeSide();
        this.undoMovePiece();
    }

    public void nullMove() {
        this.keyList[this.moveNum] = this.zobristKey;
        this.changeSide();
        this.pcList[this.moveNum] = 0;
        this.mvList[this.moveNum] = 0;
        this.chkList[this.moveNum] = false;
        ++this.moveNum;
        ++this.distance;
    }

    public void undoNullMove() {
        --this.moveNum;
        --this.distance;
        this.changeSide();
    }

    public void fromFen(String fen) {
        this.clearBoard();
        int y = 3;
        int x = 3;
        int index = 0;
        if (index == fen.length()) {
            this.setIrrev();
            return;
        }
        char c = fen.charAt(index);
        while (c != ' ') {
            if (c == '/') {
                x = 3;
                if (++y > 12) {
                    break;
                }
            } else if (c >= '1' && c <= '9') {
                x += c - 48;
            } else if (c >= 'A' && c <= 'Z') {
                if (x <= 11) {
                    pt = Position.CHAR_TO_PIECE(c);
                    if (pt >= 0) {
                        this.addPiece(Position.COORD_XY(x, y), pt + 8);
                    }
                    ++x;
                }
            } else if (c >= 'a' && c <= 'z' && x <= 11) {
                pt = Position.CHAR_TO_PIECE((char)(c + 65 - 97));
                if (pt >= 0) {
                    this.addPiece(Position.COORD_XY(x, y), pt + 16);
                }
                ++x;
            }
            if (++index == fen.length()) {
                this.setIrrev();
                return;
            }
            c = fen.charAt(index);
        }
        if (++index == fen.length()) {
            this.setIrrev();
            return;
        }
        if (this.sdPlayer == (fen.charAt(index) == 'b' ? 0 : 1)) {
            this.changeSide();
        }
        this.setIrrev();
    }

    public String toFen() {
        StringBuilder fen = new StringBuilder();
        for (int y = 3; y <= 12; ++y) {
            int k = 0;
            for (int x = 3; x <= 11; ++x) {
                byte pc = this.squares[Position.COORD_XY(x, y)];
                if (pc > 0) {
                    if (k > 0) {
                        fen.append((char)(48 + k));
                        k = 0;
                    }
                    fen.append(FEN_PIECE.charAt(pc));
                    continue;
                }
                ++k;
            }
            if (k > 0) {
                fen.append((char)(48 + k));
            }
            fen.append('/');
        }
        fen.setCharAt(fen.length() - 1, ' ');
        fen.append(this.sdPlayer == 0 ? (char)'w' : 'b');
        return fen.toString();
    }

    public int generateAllMoves(int[] mvs) {
        return this.generateMoves(mvs, null);
    }

    public int generateMoves(int[] mvs, int[] vls) {
        int moves = 0;
        int pcSelfSide = Position.SIDE_TAG(this.sdPlayer);
        int pcOppSide = Position.OPP_SIDE_TAG(this.sdPlayer);
        block9: for (int sqSrc = 0; sqSrc < 256; ++sqSrc) {
            byte pcSrc = this.squares[sqSrc];
            if ((pcSrc & pcSelfSide) == 0) continue;
            switch (pcSrc - pcSelfSide) {
                case 0: {
                    byte pcDst;
                    int sqDst;
                    int i;
                    for (i = 0; i < 4; ++i) {
                        sqDst = sqSrc + KING_DELTA[i];
                        if (!Position.IN_FORT(sqDst)) continue;
                        pcDst = this.squares[sqDst];
                        if (vls == null) {
                            if ((pcDst & pcSelfSide) != 0) continue;
                            mvs[moves] = Position.MOVE(sqSrc, sqDst);
                            ++moves;
                            continue;
                        }
                        if ((pcDst & pcOppSide) == 0) continue;
                        mvs[moves] = Position.MOVE(sqSrc, sqDst);
                        vls[moves] = Position.MVV_LVA(pcDst, 5);
                        ++moves;
                    }
                    continue block9;
                }
                case 1: {
                    byte pcDst;
                    int sqDst;
                    int i;
                    for (i = 0; i < 4; ++i) {
                        sqDst = sqSrc + ADVISOR_DELTA[i];
                        if (!Position.IN_FORT(sqDst)) continue;
                        pcDst = this.squares[sqDst];
                        if (vls == null) {
                            if ((pcDst & pcSelfSide) != 0) continue;
                            mvs[moves] = Position.MOVE(sqSrc, sqDst);
                            ++moves;
                            continue;
                        }
                        if ((pcDst & pcOppSide) == 0) continue;
                        mvs[moves] = Position.MOVE(sqSrc, sqDst);
                        vls[moves] = Position.MVV_LVA(pcDst, 1);
                        ++moves;
                    }
                    continue block9;
                }
                case 2: {
                    byte pcDst;
                    int sqDst;
                    int i;
                    for (i = 0; i < 4; ++i) {
                        sqDst = sqSrc + ADVISOR_DELTA[i];
                        if (!Position.IN_BOARD(sqDst) || !Position.HOME_HALF(sqDst, this.sdPlayer) || this.squares[sqDst] != 0) continue;
                        pcDst = this.squares[sqDst += ADVISOR_DELTA[i]];
                        if (vls == null) {
                            if ((pcDst & pcSelfSide) != 0) continue;
                            mvs[moves] = Position.MOVE(sqSrc, sqDst);
                            ++moves;
                            continue;
                        }
                        if ((pcDst & pcOppSide) == 0) continue;
                        mvs[moves] = Position.MOVE(sqSrc, sqDst);
                        vls[moves] = Position.MVV_LVA(pcDst, 1);
                        ++moves;
                    }
                    continue block9;
                }
                case 3: {
                    byte pcDst;
                    int sqDst;
                    int i;
                    for (i = 0; i < 4; ++i) {
                        sqDst = sqSrc + KING_DELTA[i];
                        if (this.squares[sqDst] > 0) continue;
                        for (int j = 0; j < 2; ++j) {
                            sqDst = sqSrc + KNIGHT_DELTA[i][j];
                            if (!Position.IN_BOARD(sqDst)) continue;
                            pcDst = this.squares[sqDst];
                            if (vls == null) {
                                if ((pcDst & pcSelfSide) != 0) continue;
                                mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                ++moves;
                                continue;
                            }
                            if ((pcDst & pcOppSide) == 0) continue;
                            mvs[moves] = Position.MOVE(sqSrc, sqDst);
                            vls[moves] = Position.MVV_LVA(pcDst, 1);
                            ++moves;
                        }
                    }
                    continue block9;
                }
                case 4: {
                    int sqDst;
                    int delta;
                    byte pcDst;
                    int i;
                    block15: for (i = 0; i < 4; ++i) {
                        delta = KING_DELTA[i];
                        sqDst = sqSrc + delta;
                        while (Position.IN_BOARD(sqDst)) {
                            pcDst = this.squares[sqDst];
                            if (pcDst == 0) {
                                if (vls == null) {
                                    mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                    ++moves;
                                }
                            } else {
                                if ((pcDst & pcOppSide) == 0) continue block15;
                                mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                if (vls != null) {
                                    vls[moves] = Position.MVV_LVA(pcDst, 4);
                                }
                                ++moves;
                                continue block15;
                            }
                            sqDst += delta;
                        }
                    }
                    continue block9;
                }
                case 5: {
                    int sqDst;
                    int delta;
                    byte pcDst;
                    int i;
                    block17: for (i = 0; i < 4; ++i) {
                        delta = KING_DELTA[i];
                        sqDst = sqSrc + delta;
                        while (Position.IN_BOARD(sqDst) && (pcDst = this.squares[sqDst]) == 0) {
                            if (vls == null) {
                                mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                ++moves;
                            }
                            sqDst += delta;
                        }
                        sqDst += delta;
                        while (Position.IN_BOARD(sqDst)) {
                            pcDst = this.squares[sqDst];
                            if (pcDst > 0) {
                                if ((pcDst & pcOppSide) == 0) continue block17;
                                mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                if (vls != null) {
                                    vls[moves] = Position.MVV_LVA(pcDst, 4);
                                }
                                ++moves;
                                continue block17;
                            }
                            sqDst += delta;
                        }
                    }
                    continue block9;
                }
                case 6: {
                    int delta;
                    byte pcDst;
                    int sqDst = Position.SQUARE_FORWARD(sqSrc, this.sdPlayer);
                    if (Position.IN_BOARD(sqDst)) {
                        byte pcDst2 = this.squares[sqDst];
                        if (vls == null) {
                            if ((pcDst2 & pcSelfSide) == 0) {
                                mvs[moves] = Position.MOVE(sqSrc, sqDst);
                                ++moves;
                            }
                        } else if ((pcDst2 & pcOppSide) != 0) {
                            mvs[moves] = Position.MOVE(sqSrc, sqDst);
                            vls[moves] = Position.MVV_LVA(pcDst2, 2);
                            ++moves;
                        }
                    }
                    if (!Position.AWAY_HALF(sqSrc, this.sdPlayer)) continue block9;
                    for (delta = -1; delta <= 1; delta += 2) {
                        sqDst = sqSrc + delta;
                        if (!Position.IN_BOARD(sqDst)) continue;
                        pcDst = this.squares[sqDst];
                        if (vls == null) {
                            if ((pcDst & pcSelfSide) != 0) continue;
                            mvs[moves] = Position.MOVE(sqSrc, sqDst);
                            ++moves;
                            continue;
                        }
                        if ((pcDst & pcOppSide) == 0) continue;
                        mvs[moves] = Position.MOVE(sqSrc, sqDst);
                        vls[moves] = Position.MVV_LVA(pcDst, 2);
                        ++moves;
                    }
                    continue block9;
                }
            }
        }
        return moves;
    }

    public boolean legalMove(int mv) {
        int pcSelfSide;
        int sqSrc = Position.SRC(mv);
        byte pcSrc = this.squares[sqSrc];
        if ((pcSrc & (pcSelfSide = Position.SIDE_TAG(this.sdPlayer))) == 0) {
            return false;
        }
        int sqDst = Position.DST(mv);
        byte pcDst = this.squares[sqDst];
        if ((pcDst & pcSelfSide) != 0) {
            return false;
        }
        switch (pcSrc - pcSelfSide) {
            case 0: {
                return Position.IN_FORT(sqDst) && Position.KING_SPAN(sqSrc, sqDst);
            }
            case 1: {
                return Position.IN_FORT(sqDst) && Position.ADVISOR_SPAN(sqSrc, sqDst);
            }
            case 2: {
                return Position.SAME_HALF(sqSrc, sqDst) && Position.BISHOP_SPAN(sqSrc, sqDst) && this.squares[Position.BISHOP_PIN(sqSrc, sqDst)] == 0;
            }
            case 3: {
                int sqPin = Position.KNIGHT_PIN(sqSrc, sqDst);
                return sqPin != sqSrc && this.squares[sqPin] == 0;
            }
            case 4: 
            case 5: {
                int sqPin;
                int delta;
                if (Position.SAME_RANK(sqSrc, sqDst)) {
                    delta = sqDst < sqSrc ? -1 : 1;
                } else if (Position.SAME_FILE(sqSrc, sqDst)) {
                    delta = sqDst < sqSrc ? -16 : 16;
                } else {
                    return false;
                }
                for (sqPin = sqSrc + delta; sqPin != sqDst && this.squares[sqPin] == 0; sqPin += delta) {
                }
                if (sqPin == sqDst) {
                    return pcDst == 0 || pcSrc - pcSelfSide == 4;
                }
                if (pcDst == 0 || pcSrc - pcSelfSide == 4) {
                    return false;
                }
                while ((sqPin += delta) != sqDst && this.squares[sqPin] == 0) {
                }
                return sqPin == sqDst;
            }
            case 6: {
                if (Position.AWAY_HALF(sqDst, this.sdPlayer) && (sqDst == sqSrc - 1 || sqDst == sqSrc + 1)) {
                    return true;
                }
                return sqDst == Position.SQUARE_FORWARD(sqSrc, this.sdPlayer);
            }
        }
        return false;
    }

    public boolean checked() {
        int pcSelfSide = Position.SIDE_TAG(this.sdPlayer);
        int pcOppSide = Position.OPP_SIDE_TAG(this.sdPlayer);
        for (int sqSrc = 0; sqSrc < 256; ++sqSrc) {
            int i;
            if (this.squares[sqSrc] != pcSelfSide + 0) continue;
            if (this.squares[Position.SQUARE_FORWARD(sqSrc, this.sdPlayer)] == pcOppSide + 6) {
                return true;
            }
            for (int delta = -1; delta <= 1; delta += 2) {
                if (this.squares[sqSrc + delta] != pcOppSide + 6) continue;
                return true;
            }
            for (i = 0; i < 4; ++i) {
                if (this.squares[sqSrc + ADVISOR_DELTA[i]] != 0) continue;
                for (int j = 0; j < 2; ++j) {
                    byte pcDst = this.squares[sqSrc + KNIGHT_CHECK_DELTA[i][j]];
                    if (pcDst != pcOppSide + 3) continue;
                    return true;
                }
            }
            block4: for (i = 0; i < 4; ++i) {
                byte pcDst;
                int delta = KING_DELTA[i];
                int sqDst = sqSrc + delta;
                while (Position.IN_BOARD(sqDst)) {
                    pcDst = this.squares[sqDst];
                    if (pcDst > 0) {
                        if (pcDst != pcOppSide + 4 && pcDst != pcOppSide + 0) break;
                        return true;
                    }
                    sqDst += delta;
                }
                sqDst += delta;
                while (Position.IN_BOARD(sqDst)) {
                    pcDst = this.squares[sqDst];
                    if (pcDst > 0) {
                        if (pcDst != pcOppSide + 5) continue block4;
                        return true;
                    }
                    sqDst += delta;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isMate() {
        int[] mvs = new int[128];
        int moves = this.generateAllMoves(mvs);
        for (int i = 0; i < moves; ++i) {
            if (!this.makeMove(mvs[i])) continue;
            this.undoMakeMove();
            return false;
        }
        return true;
    }

    public int mateValue() {
        return this.distance - 10000;
    }

    public int banValue() {
        return this.distance - 9900;
    }

    public int drawValue() {
        return (this.distance & 1) == 0 ? -20 : 20;
    }

    public int evaluate() {
        int vl = (this.sdPlayer == 0 ? this.vlWhite - this.vlBlack : this.vlBlack - this.vlWhite) + 3;
        return vl == this.drawValue() ? vl - 1 : vl;
    }

    public boolean nullOkay() {
        return (this.sdPlayer == 0 ? this.vlWhite : this.vlBlack) > 200;
    }

    public boolean nullSafe() {
        return (this.sdPlayer == 0 ? this.vlWhite : this.vlBlack) > 400;
    }

    public boolean inCheck() {
        return this.chkList[this.moveNum - 1];
    }

    public boolean captured() {
        return this.pcList[this.moveNum - 1] > 0;
    }

    public int repValue(int vlRep) {
        int vlReturn = ((vlRep & 2) == 0 ? 0 : this.banValue()) + ((vlRep & 4) == 0 ? 0 : -this.banValue());
        return vlReturn == 0 ? this.drawValue() : vlReturn;
    }

    public int repStatus() {
        return this.repStatus(1);
    }

    public int repStatus(int recur_) {
        int recur = recur_;
        boolean selfSide = false;
        boolean perpCheck = true;
        boolean oppPerpCheck = true;
        int index = this.moveNum - 1;
        while (this.mvList[index] > 0 && this.pcList[index] == 0) {
            if (selfSide) {
                boolean bl = perpCheck = perpCheck && this.chkList[index];
                if (this.keyList[index] == this.zobristKey && --recur == 0) {
                    return 1 + (perpCheck ? 2 : 0) + (oppPerpCheck ? 4 : 0);
                }
            } else {
                oppPerpCheck = oppPerpCheck && this.chkList[index];
            }
            selfSide = !selfSide;
            --index;
        }
        return 0;
    }

    public Position mirror() {
        Position pos = new Position();
        pos.clearBoard();
        for (int sq = 0; sq < 256; ++sq) {
            byte pc = this.squares[sq];
            if (pc <= 0) continue;
            pos.addPiece(Position.MIRROR_SQUARE(sq), pc);
        }
        if (this.sdPlayer == 1) {
            pos.changeSide();
        }
        return pos;
    }

    public int bookMove() {
        if (bookSize == 0) {
            return 0;
        }
        boolean mirror = false;
        int lock = this.zobristLock >>> 1;
        int index = Util.binarySearch(lock, bookLock, 0, bookSize);
        if (index < 0) {
            mirror = true;
            lock = this.mirror().zobristLock >>> 1;
            index = Util.binarySearch(lock, bookLock, 0, bookSize);
        }
        if (index < 0) {
            return 0;
        }
        while (--index >= 0 && bookLock[index] == lock) {
        }
        int[] mvs = new int[128];
        int[] vls = new int[128];
        int value = 0;
        int moves = 0;
        ++index;
        while (index < bookSize && bookLock[index] == lock) {
            int mv = 0xFFFF & bookMove[index];
            int n = mv = mirror ? Position.MIRROR_MOVE(mv) : mv;
            if (this.legalMove(mv)) {
                mvs[moves] = mv;
                vls[moves] = bookValue[index];
                value += vls[moves];
                if (++moves == 128) break;
            }
            ++index;
        }
        if (value == 0) {
            return 0;
        }
        value = Math.abs(random.nextInt()) % value;
        for (index = 0; index < moves && (value -= vls[index]) >= 0; ++index) {
        }
        return mvs[index];
    }

    public int historyIndex(int mv) {
        return (this.squares[Position.SRC(mv)] - 8 << 8) + Position.DST(mv);
    }

    /*
     * Opcode count of 13679 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        PreGen_zobristKeyTable = new int[14][256];
        PreGen_zobristLockTable = new int[14][256];
        random = new Random();
        bookSize = 0;
        bookLock = new int[16384];
        bookMove = new short[16384];
        bookValue = new short[16384];
        Util.RC4 rc4 = new Util.RC4(new byte[]{0});
        PreGen_zobristKeyPlayer = rc4.nextLong();
        rc4.nextLong();
        PreGen_zobristLockPlayer = rc4.nextLong();
        for (int i = 0; i < 14; ++i) {
            for (int j = 0; j < 256; ++j) {
                Position.PreGen_zobristKeyTable[i][j] = rc4.nextLong();
                rc4.nextLong();
                Position.PreGen_zobristLockTable[i][j] = rc4.nextLong();
            }
        }
        InputStream in = rc4.getClass().getResourceAsStream("/assets/touhou_little_maid/book/cchess/BOOK.DAT");
        if (in != null) {
            try {
                while (bookSize < 16384) {
                    Position.bookLock[Position.bookSize] = Util.readInt(in) >>> 1;
                    Position.bookMove[Position.bookSize] = (short)Util.readShort(in);
                    Position.bookValue[Position.bookSize] = (short)Util.readShort(in);
                    ++bookSize;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

